/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto.meowallet;

import java.math.BigDecimal;
import java.util.List;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletCardPayment;
import org.fenixedu.treasury.dto.meowallet.MeoWalletClientBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletMbBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletMbwayPayment;
import org.fenixedu.treasury.dto.meowallet.MeoWalletPaymentItemBean;
import org.joda.time.DateTime;

public class MeoWalletPaymentBean
implements DigitalPlatformResultBean {
    private BigDecimal amount;
    private MeoWalletClientBean client;
    private DateTime create_date;
    private String currency;
    private DateTime date;
    private DateTime expires;
    private String ext_invoiceid;
    private String ext_customerid;
    private String id;
    private MeoWalletPaymentItemBean[] items;
    private MeoWalletMbBean mb;
    private String method;
    private DateTime modified_date;
    private String status;
    private String type;
    private MeoWalletMbwayPayment mbway;
    private MeoWalletCardPayment card;
    private String callback;
    private String requestLog;
    private String responseLog;

    public MeoWalletPaymentBean(String entityCode, String referenceCode, String status) {
        this.mb = new MeoWalletMbBean();
        this.mb.setEntity(entityCode);
        this.mb.setRef(referenceCode);
        this.status = status;
    }

    public MeoWalletPaymentBean(BigDecimal payableAmount, String customerName, List<MeoWalletPaymentItemBean> items) {
        this.amount = payableAmount;
        this.client = new MeoWalletClientBean(customerName);
        this.items = new MeoWalletPaymentItemBean[items.size()];
        this.items = items.toArray(this.items);
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public MeoWalletClientBean getClient() {
        return this.client;
    }

    public void setClient(MeoWalletClientBean client) {
        this.client = client;
    }

    public DateTime getCreate_date() {
        return this.create_date;
    }

    public void setCreate_date(DateTime create_date) {
        this.create_date = create_date;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime date) {
        this.date = date;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public void setExpires(DateTime expires) {
        this.expires = expires;
    }

    public String getExt_invoiceid() {
        return this.ext_invoiceid;
    }

    public void setExt_invoiceid(String ext_invoiceid) {
        this.ext_invoiceid = ext_invoiceid;
    }

    public String getExt_customerid() {
        return this.ext_customerid;
    }

    public void setExt_customerid(String ext_customerid) {
        this.ext_customerid = ext_customerid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MeoWalletPaymentItemBean[] getItems() {
        return this.items;
    }

    public void setItems(MeoWalletPaymentItemBean[] items) {
        this.items = items;
    }

    public MeoWalletMbBean getMb() {
        return this.mb;
    }

    public void setMb(MeoWalletMbBean mb) {
        this.mb = mb;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public DateTime getModified_date() {
        return this.modified_date;
    }

    public void setModified_date(DateTime modified_date) {
        this.modified_date = modified_date;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MeoWalletMbwayPayment getMbway() {
        return this.mbway;
    }

    public void setMbway(MeoWalletMbwayPayment mbway) {
        this.mbway = mbway;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(String requestLog) {
        this.requestLog = requestLog;
    }

    public String getResponseLog() {
        return this.responseLog;
    }

    public void setResponseLog(String responseLog) {
        this.responseLog = responseLog;
    }

    public static MeoWalletPaymentBean createMbwayPaymentBean(BigDecimal payableAmount, String extInvoiceId, String extCustomerId, String customerName, String localPhoneNumber, List<MeoWalletPaymentItemBean> items) {
        MeoWalletPaymentBean result = new MeoWalletPaymentBean(payableAmount, customerName, items);
        result.setExt_invoiceid(extInvoiceId);
        result.setExt_customerid(extCustomerId);
        result.setMbway(new MeoWalletMbwayPayment(localPhoneNumber));
        result.setMethod("MBWAY");
        result.setType("PAYMENT");
        result.setCurrency("EUR");
        return result;
    }

    public static MeoWalletPaymentBean createMBPaymentBean(BigDecimal payableAmount, String extInvoiceId, String extCustomerId, String customerName, List<MeoWalletPaymentItemBean> items) {
        MeoWalletPaymentBean result = new MeoWalletPaymentBean(payableAmount, customerName, items);
        result.setExt_invoiceid(extInvoiceId);
        result.setExt_customerid(extCustomerId);
        result.setCurrency("EUR");
        return result;
    }

    public static MeoWalletPaymentBean createForwardPaymentBean(BigDecimal payableAmount, String customerName, List<MeoWalletPaymentItemBean> items) {
        MeoWalletPaymentBean result = new MeoWalletPaymentBean(payableAmount, customerName, items);
        result.setCurrency("EUR");
        return result;
    }

    public MeoWalletCardPayment getCard() {
        return this.card;
    }

    public void setCard(MeoWalletCardPayment card) {
        this.card = card;
    }

    @Override
    public String getTransactionId() {
        return this.getId();
    }

    @Override
    public String getMerchantTransactionId() {
        return this.getExt_invoiceid();
    }

    @Override
    public String getPaymentType() {
        return this.getMethod();
    }

    @Override
    public String getPaymentBrand() {
        return this.getCard() != null ? this.getCard().getType() : null;
    }

    @Override
    public String getTimestamp() {
        return this.getDate().toString("YYYY-MM-DDThh:mm:ssTZD");
    }

    @Override
    public DateTime getPaymentDate() {
        return this.modified_date;
    }

    @Override
    public boolean isPaid() {
        return "COMPLETED".equals(this.getStatus());
    }

    public boolean isPending() {
        return "PENDING".equals(this.getStatus());
    }

    public boolean isVoided() {
        return "VOIDED".equals(this.getStatus());
    }

    public boolean isFailed() {
        return "FAIL".equals(this.getStatus());
    }

    @Override
    public boolean isOperationSuccess() {
        return !"FAIL".equals(this.getStatus());
    }

    @Override
    public String getPaymentResultCode() {
        return this.getStatus();
    }

    @Override
    public String getPaymentResultDescription() {
        return null;
    }
}

