/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.util.Comparator;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.payments.integration.IPaymentRequestState;
import org.fenixedu.treasury.util.TreasuryConstants;

public enum ForwardPaymentStateType implements IPaymentRequestState
{
    CREATED,
    REQUESTED,
    AUTHENTICATED,
    AUTHORIZED,
    PAYED,
    REJECTED;

    public static final Comparator<ForwardPaymentStateType> COMPARE_BY_LOCALIZED_NAME;

    public boolean isCreated() {
        return this == CREATED;
    }

    public boolean isRequested() {
        return this == REQUESTED;
    }

    public boolean isAuthenticated() {
        return this == AUTHENTICATED;
    }

    public boolean isAuthorized() {
        return this == AUTHORIZED;
    }

    public boolean isPayed() {
        return this == PAYED;
    }

    public boolean isRejected() {
        return this == REJECTED;
    }

    public boolean isInStateToPostProcessPayment() {
        return this.isCreated() || this.isRequested();
    }

    @Override
    public LocalizedString getLocalizedName() {
        return TreasuryConstants.treasuryBundleI18N(this.getClass().getSimpleName() + "." + this.name(), new String[0]);
    }

    @Override
    public String getCode() {
        return this.name();
    }

    static {
        COMPARE_BY_LOCALIZED_NAME = new Comparator<ForwardPaymentStateType>(){

            @Override
            public int compare(ForwardPaymentStateType o1, ForwardPaymentStateType o2) {
                int c = o1.getLocalizedName().compareTo(o2.getLocalizedName());
                return c != 0 ? c : o1.compareTo(o2);
            }
        };
    }
}

