/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.sap;

import java.math.BigDecimal;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SAPExporterUtils {
    public static BigDecimal openAmountAtDate(InvoiceEntry invoiceEntry, DateTime when) {
        Currency currency = invoiceEntry.getDebtAccount().getFinantialInstitution().getCurrency();
        if (invoiceEntry.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal openAmount = invoiceEntry.getAmountWithVat().subtract(SAPExporterUtils.payedAmountAtDate(invoiceEntry, when));
        return Currency.getValueWithScale(TreasuryConstants.isPositive(openAmount) ? openAmount : BigDecimal.ZERO);
    }

    public static BigDecimal payedAmountAtDate(InvoiceEntry invoiceEntry, DateTime when) {
        BigDecimal amount = BigDecimal.ZERO;
        for (SettlementEntry entry : invoiceEntry.getSettlementEntriesSet()) {
            if (!entry.getCloseDate().isBefore((ReadableInstant)when) || entry.getFinantialDocument() == null || !entry.getFinantialDocument().isClosed()) continue;
            amount = amount.add(entry.getTotalAmount());
        }
        return amount;
    }

    public static BigDecimal amountAtDate(Invoice invoice, DateTime when) {
        BigDecimal amount = BigDecimal.ZERO;
        for (FinantialDocumentEntry entry : invoice.getFinantialDocumentEntriesSet()) {
            amount = amount.add(SAPExporterUtils.openAmountAtDate((InvoiceEntry)((Object)entry), when));
        }
        invoice.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(amount);
    }

    public static BigDecimal netAmountAtDate(Invoice invoice, DateTime when) {
        BigDecimal amount = BigDecimal.ZERO;
        for (FinantialDocumentEntry entry : invoice.getFinantialDocumentEntriesSet()) {
            if (!TreasuryConstants.isPositive(entry.getTotalAmount())) continue;
            BigDecimal entryAmountAtDate = SAPExporterUtils.openAmountAtDate((InvoiceEntry)((Object)entry), when);
            entryAmountAtDate = TreasuryConstants.divide(entry.getNetAmount().multiply(entryAmountAtDate), entry.getTotalAmount());
            amount = amount.add(entryAmountAtDate);
        }
        invoice.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(amount);
    }
}

