/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paypal;

import java.math.BigDecimal;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.paypal.PayPalLog_Base;
import org.joda.time.DateTime;

public class PayPalLog
extends PayPalLog_Base {
    public static final String WEBHOOK_NOTIFICATION = "WEBHOOK_NOTIFICATION";

    public PayPalLog() {
    }

    public PayPalLog(String operationCode, String payPalId) {
        this.setOperationCode(operationCode);
        this.setPayPalId(payPalId);
    }

    public PayPalLog(PaymentRequest paymentRequest, String statusCode, LocalizedString stateDescription) {
        this();
        this.setPaymentRequest(paymentRequest);
        this.setStatusCode(statusCode);
        this.setStateDescription(stateDescription);
    }

    public String getInternalMerchantTransactionId() {
        return null;
    }

    public String getExternalTransactionId() {
        return super.getPayPalId();
    }

    public void setPayPalId(String payPalId) {
        super.setPayPalId(payPalId);
        super.setExternalTransactionId(payPalId);
    }

    public void savePaymentInfo(BigDecimal payedAmount, DateTime transactionDate) {
        this.setPaymentDate(transactionDate);
        this.setAmount(payedAmount);
    }

    public static PayPalLog createPaymentRequestLog(PaymentRequest paymentRequest, String code, LocalizedString localizedName) {
        return new PayPalLog(paymentRequest, code, localizedName);
    }

    public static PayPalLog createLogForWebhookNotification() {
        PayPalLog log2 = new PayPalLog(WEBHOOK_NOTIFICATION, "");
        log2.setResponsibleUsername(WEBHOOK_NOTIFICATION);
        return log2;
    }

    public void logRequestReceiveDateAndData(String transactionId, String string, String event_type, BigDecimal amount, String resource_type, boolean operationSuccess) {
        this.setRequestReceiveDate(new DateTime());
        this.setPayPalId(transactionId);
        this.setPaymentMethod(event_type);
        this.setAmount(amount);
        this.setStatusCode(resource_type);
        this.setOperationSuccess(operationSuccess);
    }
}

