/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.CustomerType$callable$create;
import org.fenixedu.treasury.domain.CustomerType$callable$delete;
import org.fenixedu.treasury.domain.CustomerType$callable$edit;
import org.fenixedu.treasury.domain.CustomerType_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CustomerType
extends CustomerType_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CustomerType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected CustomerType(String code, LocalizedString name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.CustomerType.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.CustomerType.name.required", new String[0]);
        }
        if (CustomerType.findByCode(this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.CustomerType.code.duplicated", new String[0]);
        }
        this.getName().getLocales().stream().forEach(l -> CustomerType.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new CustomerType$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(CustomerType this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getCustomersSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CustomerType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CustomerType this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.CustomerType.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<CustomerType> findAll() {
        return FenixFramework.getDomainRoot().getCustomerTypesSet().stream();
    }

    public static Stream<CustomerType> findByCode(String code) {
        return CustomerType.findAll().filter(ct -> ct.getCode().equalsIgnoreCase(code));
    }

    public static Stream<CustomerType> findByName(String name) {
        return CustomerType.findAll().filter(ct -> ct.getName().equals((Object)name));
    }

    public static CustomerType create(String string, LocalizedString localizedString) {
        return (CustomerType)((Object)advice$create.perform((Callable)new CustomerType$callable$create(string, localizedString)));
    }

    static /* synthetic */ CustomerType advised$create(String code, LocalizedString name) {
        return new CustomerType(code, name);
    }
}

