/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.accesscontrol.spi;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.DynamicGroup;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalYear;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControlConfiguration;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class TreasuryUIAccessControlExtension
implements ITreasuryAccessControlExtension<Object> {
    private static final String TREASURY_MANAGERS = "treasuryManagers";
    private static final String TREASURY_BACK_OFFICE = "treasuryBackOffice";
    private static final String TREASURY_FRONT_OFFICE = "treasuryFrontOffice";
    private static final String TREASURY_ALLOW_TO_ANNUL_SETTLEMENT_NOTES_WITHOUT_RESTRICTIONS = "treasuryAllowAnnulSettlementsWithoutAnyRestriction";

    @Override
    public boolean isFrontOfficeMember(String username) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    @Override
    public boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    @Override
    public boolean isBackOfficeMember(String username) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    @Override
    public boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    @Override
    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    @Override
    public boolean isManager(String username) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_MANAGERS).isMember(user);
    }

    @Override
    public boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    @Override
    @Deprecated
    public boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    @Override
    public boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        int year;
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        FinantialInstitution finantialInstitution = settlementNote.getDebtAccount().getFinantialInstitution();
        if (!TreasuryAccessControlAPI.isAllowToModifySettlements(username, finantialInstitution)) {
            return false;
        }
        if (settlementNote.getPaymentTransaction() != null) {
            return false;
        }
        LocalDate annulmentControlDate = settlementNote.getErpCertificationDate();
        if (annulmentControlDate == null) {
            if (settlementNote.isExportedInLegacyERP()) {
                return false;
            }
            if (settlementNote.isDocumentToExport()) {
                return true;
            }
            if (settlementNote.getClearDocumentToExportDate() != null) {
                annulmentControlDate = settlementNote.getClearDocumentToExportDate().toLocalDate();
            } else {
                return false;
            }
        }
        if (!FiscalYear.findUnique(finantialInstitution, year = annulmentControlDate.getYear()).isPresent()) {
            return false;
        }
        FiscalYear fiscalYear = FiscalYear.findUnique(finantialInstitution, year).get();
        if (fiscalYear.getSettlementAnnulmentLimitDate() == null) {
            return false;
        }
        DateTime limitDateTime = fiscalYear.getSettlementAnnulmentLimitDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1);
        return !new DateTime().isAfter((ReadableInstant)limitDateTime);
    }

    @Override
    public boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return false;
        }
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_ALLOW_TO_ANNUL_SETTLEMENT_NOTES_WITHOUT_RESTRICTIONS).isMember(user);
    }

    private DynamicGroup getOrCreateDynamicGroup(String dynamicGroupName) {
        DynamicGroup dynamicGroup = DynamicGroup.get((String)dynamicGroupName);
        if (!dynamicGroup.isDefined()) {
            User manager = User.findByUsername((String)"manager");
            if (manager != null) {
                dynamicGroup.mutator().grant(manager);
            } else {
                dynamicGroup.toPersistentGroup();
            }
        }
        return dynamicGroup;
    }

    @Override
    public Set<String> getFrontOfficeMemberUsernames() {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return Collections.emptySet();
        }
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).getMembers().filter(m -> !Strings.isNullOrEmpty((String)m.getUsername())).map(m -> m.getUsername()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getBackOfficeMemberUsernames() {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return Collections.emptySet();
        }
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).getMembers().filter(m -> !Strings.isNullOrEmpty((String)m.getUsername())).map(m -> m.getUsername()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getTreasuryManagerMemberUsernames() {
        if (!TreasuryAccessControlConfiguration.isAccessControlByBennuDynamicGroups()) {
            return Collections.emptySet();
        }
        return this.getOrCreateDynamicGroup(TREASURY_MANAGERS).getMembers().filter(m -> !Strings.isNullOrEmpty((String)m.getUsername())).map(m -> m.getUsername()).collect(Collectors.toSet());
    }
}

