/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay.model;

import java.math.BigDecimal;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotification;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class SibsPayWebhookNotificationWrapper
implements DigitalPlatformResultBean {
    private SibsPayWebhookNotification webhookNotification;

    public SibsPayWebhookNotificationWrapper(SibsPayWebhookNotification webhookNotification) {
        this.webhookNotification = webhookNotification;
    }

    public void checkIfNotificationIsPaidAndPaymentReferenceIsAlsoInPaidStatus() {
        if (this.isPaid() && this.webhookNotification.getPaymentReference() != null && !"PAID".equals(this.webhookNotification.getPaymentReference().getStatus())) {
            throw new RuntimeException("the notification is paid but the status of PaymentReference is not 'PAID'");
        }
    }

    public BigDecimal getAmount() {
        return this.webhookNotification.getAmount().getValue();
    }

    public String getMerchantTransactionId() {
        if (this.webhookNotification.getMerchant() != null) {
            return this.webhookNotification.getMerchant().getTransactionId();
        }
        return null;
    }

    public String getPaymentBrand() {
        return this.webhookNotification.getPaymentMethod();
    }

    public DateTime getPaymentDate() {
        if (this.webhookNotification.getTransactionDateTime() == null) {
            return this.webhookNotification.getTransactionDateTime();
        }
        DateTime transactionDateTimeWithSibsPayTimezone = this.webhookNotification.getTransactionDateTime();
        DateTimeZone serverTimezone = DateTimeZone.getDefault();
        int serverOffsetMillis = serverTimezone.getOffset((ReadableInstant)transactionDateTimeWithSibsPayTimezone);
        DateTime dateTimeServerTimezone = transactionDateTimeWithSibsPayTimezone.withZone(DateTimeZone.forOffsetMillis((int)serverOffsetMillis));
        return dateTimeServerTimezone;
    }

    public String getPaymentResultCode() {
        return this.webhookNotification.getPaymentStatus();
    }

    public String getPaymentResultDescription() {
        return null;
    }

    public String getPaymentType() {
        return this.webhookNotification.getPaymentMethod();
    }

    public String getTimestamp() {
        return null;
    }

    public String getTransactionId() {
        return this.webhookNotification.getTransactionID();
    }

    public String getOperationStatusCode() {
        return this.webhookNotification.getReturnStatus().getStatusCode();
    }

    public String getOperationStatusMessage() {
        return this.webhookNotification.getReturnStatus().getStatusMsg();
    }

    public String getOperationStatusDescription() {
        return this.webhookNotification.getReturnStatus().getStatusDescription();
    }

    public String getNotificationID() {
        return this.webhookNotification.getNotificationID();
    }

    public boolean isOperationSuccess() {
        return SibsPayAPIService.isOperationSuccess(this.webhookNotification.getReturnStatus().getStatusCode());
    }

    public boolean isPaid() {
        if (!SibsPayAPIService.isPaymentTypePurs(this.webhookNotification.getPaymentType()) && !SibsPayAPIService.isPaymentTypePref(this.webhookNotification.getPaymentType())) {
            return false;
        }
        return SibsPayAPIService.isPaid(this.getPaymentResultCode());
    }

    public boolean isPending() {
        return SibsPayAPIService.isPending(this.getPaymentResultCode());
    }

    public boolean isExpired() {
        return SibsPayAPIService.isExpired(this.getPaymentResultCode());
    }

    public boolean isDeclined() {
        return SibsPayAPIService.isDeclined(this.getPaymentResultCode());
    }

    public boolean isAuthorizationAccepted() {
        return SibsPayAPIService.isAuthorizationAccepted(this.getPaymentResultCode());
    }

    public boolean isSibsPayPaymentTypeAuth() {
        return SibsPayAPIService.isPaymentTypeAuth(this.webhookNotification.getPaymentType());
    }

    public String getMandateId() {
        if (this.webhookNotification.getMbwayMandate() != null) {
            return this.webhookNotification.getMbwayMandate().getMandateIdentification();
        }
        return null;
    }

    public boolean IsMandateActionAuthCreation() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionAuthCreation(this.webhookNotification.getMbwayMandate().getMandateAction());
    }

    public boolean isMandateActionAuthSuspension() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionAuthSuspension(this.webhookNotification.getMbwayMandate().getMandateAction());
    }

    public boolean isMandateActionAuthReactivation() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionAuthReactivation(this.webhookNotification.getMbwayMandate().getMandateAction());
    }

    public boolean isMandateActionAuthLimitsUpdate() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionAuthLimitsUpdate(this.webhookNotification.getMbwayMandate().getMandateAction());
    }

    public boolean isMandateActionAuthCancel() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionAuthCancel(this.webhookNotification.getMbwayMandate().getMandateAction());
    }

    public boolean IsMandateActionStatusSuccess() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionStatusSuccess(this.webhookNotification.getMbwayMandate().getMandateActionStatus());
    }

    public boolean isMandateActionStatusRejected() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionStatusRejected(this.webhookNotification.getMbwayMandate().getMandateActionStatus());
    }

    public boolean isMandateActionStatusRefused() {
        return this.webhookNotification.getMbwayMandate() != null && SibsPayAPIService.isMandateActionStatusRefused(this.webhookNotification.getMbwayMandate().getMandateActionStatus());
    }

    public BigDecimal getPlafond() {
        if (this.webhookNotification.getMbwayMandate() == null) {
            return null;
        }
        if (this.webhookNotification.getMbwayMandate().getMandateAmountLimit() == null) {
            return null;
        }
        return this.webhookNotification.getMbwayMandate().getMandateAmountLimit().getValue();
    }

    public LocalDate getAuthorizationExpirationDate() {
        if (this.webhookNotification.getMbwayMandate() == null) {
            return null;
        }
        if (this.webhookNotification.getMbwayMandate().getMandateExpirationDate() == null) {
            return null;
        }
        String value = this.webhookNotification.getMbwayMandate().getMandateExpirationDate();
        if (value.length() > 10) {
            value = value.substring(0, 10);
        }
        return TreasuryConstants.parseLocalDate(value, "yyyy-MM-dd");
    }
}

