/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.meowallet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Feature;
import org.fenixedu.onlinepaymentsgateway.api.SIBSOnlinePaymentsGatewayService;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.dto.meowallet.MeoWalletCheckoutBean;
import org.fenixedu.treasury.dto.meowallet.MeoWalletPaymentBean;
import org.glassfish.jersey.logging.LoggingFeature;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class MeoWalletService {
    private static final String WALLETS_METHODS = "wallets/methods";
    private static final String PAYMENT_PATH = "payment";
    private static final String MB_PAY_PATH = "mb/pay";
    private static final String WS_ACCESS_TOKEN_HEADER = "Authorization";
    private static final String WS_ACCESS_TOKEN_VALUE_PREFIX = "WalletPT ";
    private static final String CHECKOUT_PATH = "checkout";
    private static final String OPERATION_PATH = "operations";
    private static final String DELETE_MB_REF_PATH = "mb/reference";
    private Feature feature = new LoggingFeature(Logger.getLogger(SIBSOnlinePaymentsGatewayService.class.getName()), Level.FINEST, (LoggingFeature.Verbosity)null, (Integer)null);
    private Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)this.feature)).build();
    private WebTarget webTargetBase;
    private String endpointUrl;
    private String token;

    public MeoWalletService(String endpointUrl, String token) {
        if (endpointUrl != null) {
            this.webTargetBase = this.client.target(endpointUrl);
        }
        this.endpointUrl = endpointUrl;
        this.token = token;
    }

    public void closeClient() {
        this.client.close();
    }

    public MeoWalletPaymentBean generateMbwayReference(MeoWalletPaymentBean payment) throws OnlinePaymentsGatewayCommunicationException {
        String requestLog = this.getGson().toJson((Object)payment);
        String responseLog = this.processPost(PAYMENT_PATH, requestLog);
        try {
            MeoWalletPaymentBean result = (MeoWalletPaymentBean)this.getGson().fromJson(responseLog, MeoWalletPaymentBean.class);
            if (result.getId() == null) {
                throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog);
            }
            result.setRequestLog(requestLog);
            result.setResponseLog(responseLog);
            return result;
        }
        catch (WebApplicationException var23) {
            responseLog = (String)var23.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, (Throwable)var23);
        }
    }

    public MeoWalletPaymentBean generateMBPaymentReference(MeoWalletPaymentBean payment) throws OnlinePaymentsGatewayCommunicationException, IOException {
        int days = Days.daysBetween((ReadableInstant)DateTime.now(), (ReadableInstant)payment.getExpires()).getDays();
        if (payment.getExpires() != null && days < 2) {
            payment.setExpires(payment.getExpires().plusDays(2 - days));
        }
        Gson gson = this.getGson();
        String requestLog = gson.toJson((Object)payment);
        String responseLog = this.processPost(MB_PAY_PATH, requestLog);
        try {
            MeoWalletPaymentBean result = (MeoWalletPaymentBean)this.getGson().fromJson(responseLog, MeoWalletPaymentBean.class);
            result.setRequestLog(requestLog);
            result.setResponseLog(responseLog);
            return result;
        }
        catch (WebApplicationException var23) {
            responseLog = (String)var23.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, (Throwable)var23);
        }
    }

    public MeoWalletPaymentBean deleteMBPaymentReference(String entityCode, String referenceCode) throws OnlinePaymentsGatewayCommunicationException, IOException {
        String requestLog = String.format("{ \"entity\": \"%s\", \"reference\": \"%s\" }", entityCode, referenceCode);
        String responseLog = this.processDelete(DELETE_MB_REF_PATH, requestLog);
        try {
            String operationStatus = (String)this.getGson().fromJson(responseLog, String.class);
            boolean operationSuccess = "OK".equals(operationStatus);
            MeoWalletPaymentBean result = new MeoWalletPaymentBean(entityCode, referenceCode, operationSuccess ? "COMPLETED" : "FAIL");
            result.setRequestLog(requestLog);
            result.setResponseLog(responseLog);
            return result;
        }
        catch (WebApplicationException var23) {
            responseLog = (String)var23.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, (Throwable)var23);
        }
    }

    public MeoWalletCheckoutBean prepareOnlinePaymentCheckout(MeoWalletCheckoutBean checkoutBean) throws OnlinePaymentsGatewayCommunicationException {
        String requestLog = this.getGson().toJson((Object)checkoutBean);
        String responseLog = this.processPost(CHECKOUT_PATH, requestLog);
        System.out.println(responseLog);
        try {
            MeoWalletCheckoutBean result = (MeoWalletCheckoutBean)this.getGson().fromJson(responseLog, MeoWalletCheckoutBean.class);
            result.setRequestLog(requestLog);
            result.setResponseLog(responseLog);
            return result;
        }
        catch (WebApplicationException var23) {
            responseLog = (String)var23.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, (Throwable)var23);
        }
    }

    public MeoWalletCheckoutBean getForwardPaymentTransactionReportByCheckoutId(String id) throws OnlinePaymentsGatewayCommunicationException {
        String path = "checkout/" + id;
        String requestLog = id;
        String responseLog = this.processGetService(path, new String[0]);
        try {
            MeoWalletCheckoutBean result = (MeoWalletCheckoutBean)this.getGson().fromJson(responseLog, MeoWalletCheckoutBean.class);
            result.setRequestLog(requestLog);
            result.setResponseLog(responseLog);
            return result;
        }
        catch (WebApplicationException var23) {
            responseLog = (String)var23.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, (Throwable)var23);
        }
    }

    public MeoWalletPaymentBean getCallbackReportByTransactionId(String id) throws OnlinePaymentsGatewayCommunicationException {
        try {
            String path = "operations/" + id;
            String requestLog = id;
            String responseLog = this.processGetService(path, new String[0]);
            MeoWalletPaymentBean result = (MeoWalletPaymentBean)this.getGson().fromJson(responseLog, MeoWalletPaymentBean.class);
            result.setRequestLog(requestLog);
            result.setResponseLog(responseLog);
            return result;
        }
        catch (Exception e) {
            String responseLog = null;
            if (e instanceof WebApplicationException) {
                responseLog = (String)((WebApplicationException)((Object)e)).getResponse().readEntity(String.class);
            }
            throw new OnlinePaymentsGatewayCommunicationException(null, responseLog, (Throwable)e);
        }
    }

    public boolean verifyCallback(String webhookBody) {
        String path = "callback/verify";
        String value = this.processPost(path, webhookBody);
        return "true".equals(value);
    }

    public List<MeoWalletPaymentBean> getPaymentTransactionReportByMerchantTransactionId(String merchantTransationId) throws OnlinePaymentsGatewayCommunicationException {
        String requestLog = merchantTransationId;
        String path = OPERATION_PATH;
        String responseLog = this.processGetService(path, "ext_invoiceid", merchantTransationId);
        try {
            ArrayList<MeoWalletPaymentBean> list = new ArrayList<MeoWalletPaymentBean>();
            Gson gson = this.getGson();
            JsonArray jsonArray = ((JsonObject)gson.fromJson(responseLog, JsonObject.class)).getAsJsonArray("elements");
            for (JsonElement jsonElement : jsonArray) {
                MeoWalletPaymentBean result = (MeoWalletPaymentBean)gson.fromJson((JsonElement)jsonElement.getAsJsonObject(), MeoWalletPaymentBean.class);
                result.setRequestLog(requestLog);
                result.setResponseLog(responseLog);
                list.add(result);
            }
            return list;
        }
        catch (WebApplicationException var23) {
            responseLog = (String)var23.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, (Throwable)var23);
        }
    }

    private Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(DateTime.class, (src, srcType, context) -> new JsonPrimitive(src.toString(ISODateTimeFormat.dateTimeNoMillis()))).registerTypeAdapter(DateTime.class, (src, srcType, context) -> DateTime.parse((String)src.getAsString())).setPrettyPrinting().create();
    }

    private String processGetService(String path, String ... queryParams) {
        WebTarget target = this.webTargetBase.path(path);
        for (int i = 0; i < queryParams.length; i += 2) {
            target = target.queryParam(queryParams[i], new Object[]{queryParams[i + 1]});
        }
        Invocation.Builder builder = target.request(new String[]{"application/json"}).accept(new String[]{"application/json"});
        String responseLog = (String)builder.header(WS_ACCESS_TOKEN_HEADER, (Object)(WS_ACCESS_TOKEN_VALUE_PREFIX + this.token)).get(String.class);
        return responseLog;
    }

    private String processPost(String path, String requestLog) {
        WebTarget target = this.webTargetBase.path(path);
        Invocation.Builder builder = target.request(new String[]{"application/json"}).accept(new String[]{"application/json"});
        String responseLog = (String)builder.header(WS_ACCESS_TOKEN_HEADER, (Object)(WS_ACCESS_TOKEN_VALUE_PREFIX + this.token)).post(Entity.json((Object)requestLog)).readEntity(String.class);
        return responseLog;
    }

    private String processDelete(String path, String requestLog) {
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true)).register((Object)this.feature)).build();
        WebTarget target = client.target(this.endpointUrl).path(path);
        Invocation.Builder builder = target.request(new String[]{"application/json"}).accept(new String[]{"application/json"});
        String responseLog = (String)builder.header(WS_ACCESS_TOKEN_HEADER, (Object)(WS_ACCESS_TOKEN_VALUE_PREFIX + this.token)).build("DELETE", Entity.json((Object)requestLog)).invoke(String.class);
        return responseLog;
    }

    public String[] getMethodsExceptIncluded(String[] includes) throws OnlinePaymentsGatewayCommunicationException {
        String path = WALLETS_METHODS;
        String responseLog = this.processGetService(path, new String[0]);
        try {
            ArrayList<String> list = new ArrayList<String>();
            Gson gson = this.getGson();
            JsonArray jsonArray = ((JsonObject)gson.fromJson(responseLog, JsonObject.class)).getAsJsonArray("methods");
            for (JsonElement jsonElement : jsonArray) {
                list.add(jsonElement.getAsString());
            }
            for (String include : includes) {
                list.remove(include);
            }
            String[] stockArr = new String[list.size()];
            stockArr = list.toArray(stockArr);
            return stockArr;
        }
        catch (WebApplicationException var23) {
            throw new OnlinePaymentsGatewayCommunicationException("Error on get methods", "Error on get methods", (Throwable)var23);
        }
    }
}

