/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.PaymentMethodReference;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.Installment_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentRequest_Base;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.IPaymentRequestState;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public abstract class PaymentRequest
extends PaymentRequest_Base {
    public PaymentRequest() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setRequestDate(new DateTime());
        this.setResponsibleUsername(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
    }

    protected void init(DigitalPaymentPlatform platform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount, PaymentMethod paymentMethod) {
        for (DebitEntry debitEntry : debitEntries) {
            if (TreasuryConstants.isPositive(debitEntry.getOpenAmount())) continue;
            throw new TreasuryDomainException("error.PaymentRequest.debit.entry.open.amount.must.be.greater.than.zero", new String[0]);
        }
        for (Installment installment2 : installments) {
            if (TreasuryConstants.isPositive(installment2.getOpenAmount())) continue;
            throw new TreasuryDomainException("error.PaymentRequest.debit.entry.open.amount.must.be.greater.than.zero", new String[0]);
        }
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        debitEntries.forEach(de -> {
            if (TreasuryDebtProcessMainService.isBlockingPaymentInBackoffice((InvoiceEntry)((Object)((Object)de)))) {
                if (!TreasuryDebtProcessMainService.getBlockingPaymentReasonsForBackoffice((InvoiceEntry)((Object)((Object)de))).isEmpty()) {
                    LocalizedString reason = TreasuryDebtProcessMainService.getBlockingPaymentReasonsForBackoffice((InvoiceEntry)((Object)((Object)de))).iterator().next();
                    throw new RuntimeException(reason.getContent());
                }
                throw new TreasuryDomainException("error.PaymentRequest.not.possible.to.create.payment.request", new String[0]);
            }
        });
        installments.forEach(installment -> installment.getInstallmentEntriesSet().stream().map(de -> de.getDebitEntry()).forEach(de -> {
            if (TreasuryDebtProcessMainService.isBlockingPaymentInBackoffice((InvoiceEntry)((Object)((Object)((Object)de))))) {
                if (!TreasuryDebtProcessMainService.getBlockingPaymentReasonsForBackoffice((InvoiceEntry)((Object)((Object)((Object)de)))).isEmpty()) {
                    LocalizedString reason = TreasuryDebtProcessMainService.getBlockingPaymentReasonsForBackoffice((InvoiceEntry)((Object)((Object)((Object)de)))).iterator().next();
                    throw new RuntimeException(reason.getContent());
                }
                throw new TreasuryDomainException("error.PaymentRequest.not.possible.to.create.payment.request", new String[0]);
            }
        }));
        this.setDigitalPaymentPlatform(platform);
        this.setFinantialEntity(platform.getFinantialEntity());
        this.setDebtAccount(debtAccount);
        this.getDebitEntriesSet().addAll(debitEntries);
        this.getInstallmentsSet().addAll(installments);
        this.setPayableAmount(payableAmount);
        this.setPaymentMethod(paymentMethod);
    }

    protected void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.PaymentRequest.domainRoot.required", new String[0]);
        }
        if (this.getDigitalPaymentPlatform() == null) {
            throw new TreasuryDomainException("error.PaymentRequest.digitalPaymentPlatform.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.PaymentRequest.debtAccount.required", new String[0]);
        }
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.PaymentRequest.paymentMethod.required", new String[0]);
        }
        if (!StringUtils.isEmpty((String)this.getMerchantTransactionId()) && PaymentRequest.findBySibsGatewayMerchantTransactionId(this.getMerchantTransactionId()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentRequest.sibsGatewayMerchantTransactionId.not.unique", new String[0]);
        }
        if (!StringUtils.isEmpty((String)this.getTransactionId()) && PaymentRequest.findBySibsGatewayTransactionId(this.getTransactionId()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentRequest.sibsGatewayTransactionId.not.unique", new String[0]);
        }
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            if (debitEntry.getDebtAccount() == this.getDebtAccount()) continue;
            throw new TreasuryDomainException("error.PaymentRequest.debit.entry.not.same.debt.account", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new TreasuryDomainException("error.PaymentRequest.finantialEntity.required", new String[0]);
        }
        SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP(this.getDebitEntriesSet());
    }

    public LocalDate getDueDate() {
        if (super.getPaymentDueDate() != null) {
            return super.getPaymentDueDate();
        }
        Set map = this.getDebitEntriesSet().stream().filter(d -> !d.isAnnulled()).map(InvoiceEntry::getDueDate).collect(Collectors.toSet());
        map.addAll(this.getInstallmentsSet().stream().filter(i -> i.getPaymentPlan().getState().isOpen()).map(Installment_Base::getDueDate).collect(Collectors.toSet()));
        return map.stream().sorted().findFirst().orElse(null);
    }

    public String fillPaymentEntryMethodId() {
        Optional<PaymentMethodReference> methodReference = PaymentMethodReference.findUniqueActiveAndForDigitalPayments(this.getPaymentMethod(), this.getDebtAccount().getFinantialInstitution());
        if (methodReference.isPresent()) {
            return methodReference.get().buildPaymentReferenceId(this);
        }
        return null;
    }

    public abstract IPaymentRequestState getCurrentState();

    public abstract boolean isInCreatedState();

    public abstract boolean isInRequestedState();

    public abstract boolean isInPaidState();

    public abstract boolean isInAnnuledState();

    public Set<Customer> getReferencedCustomers() {
        return PaymentRequest.getReferencedCustomers(this.getDebitEntriesSet(), this.getInstallmentsSet());
    }

    public Set<Product> getReferencedProducts() {
        return this.getDebitEntriesSet().stream().map(d -> d.getProduct()).collect(Collectors.toSet());
    }

    protected boolean payAllDebitEntriesInterests() {
        return false;
    }

    public Set<SettlementNote> internalProcessPaymentInNormalPaymentMixingLegacyInvoices(BigDecimal paidAmount, DateTime paymentDate, String originDocumentNumber, String comments, Function<PaymentRequest, Map<String, String>> additionalPropertiesMapFunction) {
        SettlementNoteBean bean = SettlementNoteBean.createForPaymentRequestProcessPayment(this, paymentDate, paidAmount, originDocumentNumber);
        SettlementNote settlementNote = SettlementNote.createSettlementNote(bean);
        settlementNote.setDocumentObservations(comments);
        if (settlementNote.getAdvancedPaymentCreditNote() != null) {
            settlementNote.getAdvancedPaymentCreditNote().setDocumentObservations(comments);
        }
        Map<String, String> paymentEntryPropertiesMap = additionalPropertiesMapFunction.apply(this);
        PaymentEntry paymentEntry = (PaymentEntry)((Object)settlementNote.getPaymentEntriesSet().iterator().next());
        paymentEntryPropertiesMap.putAll(paymentEntry.getPropertiesMap());
        paymentEntry.editPropertiesMap(paymentEntryPropertiesMap);
        return Sets.newHashSet((Object[])new SettlementNote[]{settlementNote});
    }

    public Set<SettlementNote> internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(BigDecimal amount, DateTime paymentDate, String originDocumentNumber, String comments, Function<PaymentRequest, Map<String, String>> additionalPropertiesMapFunction) {
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            throw new RuntimeException("invalid call");
        }
        SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP(this.getDebitEntriesSet());
        if (this.getDebitEntriesSet().stream().allMatch(e -> e.getFinantialDocument() == null || !e.getFinantialDocument().isExportedInLegacyERP())) {
            return this.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(amount, paymentDate, originDocumentNumber, comments, additionalPropertiesMapFunction);
        }
        TreeSet sortedInvoiceEntriesToPay = Sets.newTreeSet(InvoiceEntry.COMPARE_BY_AMOUNT_AND_DUE_DATE);
        sortedInvoiceEntriesToPay.addAll(this.getDebitEntriesSet());
        BigDecimal availableAmount = amount;
        DocumentNumberSeries docNumberSeriesForPayments = DocumentNumberSeries.findUniqueDefaultSeries(FinantialDocumentType.findForSettlementNote(), this.getFinantialEntity());
        SettlementNote settlementNote = SettlementNote.create(this.getFinantialEntity(), this.getDebtAccount(), docNumberSeriesForPayments, new DateTime(), paymentDate, originDocumentNumber, null);
        settlementNote.setDocumentObservations(comments);
        if (this.getReferencedCustomers().size() == 1) {
            for (InvoiceEntry entry : sortedInvoiceEntriesToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal amountToPay = entry.getOpenAmount();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (entry.isDebitNoteEntry()) {
                    DebitEntry debitEntry = (DebitEntry)((Object)entry);
                    if (debitEntry.getFinantialDocument().isPreparing()) {
                        debitEntry.getFinantialDocument().closeDocument();
                    }
                    if (amountToPay.compareTo(availableAmount) > 0) {
                        amountToPay = availableAmount;
                    }
                    if (debitEntry.getOpenAmount().equals(amountToPay)) {
                        List<InterestRateBean> undebitedInterestRateBeansList = debitEntry.calculateUndebitedInterestValue(paymentDate.toLocalDate());
                        for (InterestRateBean calculateUndebitedInterestValue : undebitedInterestRateBeansList) {
                            if (!TreasuryConstants.isPositive(calculateUndebitedInterestValue.getInterestAmount())) continue;
                            DateTime whenInterestDebitEntryDateTime = calculateUndebitedInterestValue.getInterestDebitEntryDateTime() != null ? calculateUndebitedInterestValue.getInterestDebitEntryDateTime() : paymentDate;
                            debitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, whenInterestDebitEntryDateTime, null);
                        }
                    }
                    SettlementEntry.create(entry, settlementNote, amountToPay, entry.getDescription(), paymentDate, true);
                    availableAmount = availableAmount.subtract(amountToPay);
                    continue;
                }
                if (!entry.isCreditNoteEntry()) continue;
                SettlementEntry.create(entry, settlementNote, entry.getOpenAmount(), entry.getDescription(), paymentDate, true);
                availableAmount = availableAmount.add(amountToPay);
            }
        }
        if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) {
            availableAmount = BigDecimal.ZERO;
        }
        Map<String, String> paymentEntryPropertiesMap = additionalPropertiesMapFunction.apply(this);
        PaymentEntry.create(this.getPaymentMethod(), settlementNote, amount.subtract(availableAmount), this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
        settlementNote.closeDocument();
        HashSet result = Sets.newHashSet((Object[])new SettlementNote[]{settlementNote});
        if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
            SettlementNote advancedPaymentSettlementNote = SettlementNote.create(this.getFinantialEntity(), this.getDebtAccount(), docNumberSeriesForPayments, new DateTime(), paymentDate, originDocumentNumber, null);
            advancedPaymentSettlementNote.setDocumentObservations(comments);
            String advancedPaymentCreditNoteComments = String.format("%s [%s]", TreasuryConstants.treasuryBundleI18N("label.SettlementNote.advancedpayment", new String[0]).getContent(TreasuryConstants.DEFAULT_LANGUAGE), paymentDate.toString("dd/MM/yyyy"));
            advancedPaymentSettlementNote.createAdvancedPaymentCreditNote(availableAmount, advancedPaymentCreditNoteComments, originDocumentNumber);
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setDocumentObservations(comments);
            PaymentEntry.create(this.getPaymentMethod(), advancedPaymentSettlementNote, availableAmount, this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
            advancedPaymentSettlementNote.closeDocument();
            advancedPaymentSettlementNote.setExportedInLegacyERP(true);
            advancedPaymentSettlementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setExportedInLegacyERP(true);
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            result.add(advancedPaymentSettlementNote);
        }
        return result;
    }

    public static Set<Customer> getReferencedCustomers(Set<DebitEntry> debitEntrySet, Set<Installment> installments) {
        HashSet result = Sets.newHashSet();
        for (InvoiceEntry invoiceEntry : debitEntrySet) {
            if (invoiceEntry.getFinantialDocument() != null && ((Invoice)((Object)invoiceEntry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)invoiceEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(invoiceEntry.getDebtAccount().getCustomer());
        }
        for (Installment installment : installments) {
            result.addAll(installment.getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry()).map(deb -> deb.getFinantialDocument() != null && ((Invoice)((Object)((Object)((Object)((Object)deb.getFinantialDocument()))))).isForPayorDebtAccount() ? ((Invoice)((Object)((Object)((Object)((Object)deb.getFinantialDocument()))))).getPayorDebtAccount().getCustomer() : deb.getDebtAccount().getCustomer()).collect(Collectors.toSet()));
        }
        return result;
    }

    public List<DebitEntry> getOrderedDebitEntries() {
        ArrayList<DebitEntry> result = new ArrayList<DebitEntry>();
        this.getDebitEntriesSet().stream().collect(Collectors.toCollection(() -> result));
        Collections.sort(result, InvoiceEntry.COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION);
        if (result.size() != this.getDebitEntriesSet().size()) {
            throw new RuntimeException("error.PaymentEntry.getOrderedDebitEntries.ordered.result.not.equal.to.getDebitEntriesSet");
        }
        return result;
    }

    public List<Installment> getOrderedInstallments() {
        ArrayList<Installment> result = new ArrayList<Installment>();
        this.getInstallmentsSet().stream().collect(Collectors.toCollection(() -> result));
        Collections.sort(result, Installment.COMPARE_BY_DUEDATE);
        return result;
    }

    public List<? extends PaymentRequestLog> getOrderedPaymentLogs() {
        return this.getPaymentRequestLogsSet().stream().sorted(PaymentRequestLog.COMPARE_BY_CREATION_DATE.reversed()).collect(Collectors.toList());
    }

    public void delete() {
    }

    public BigDecimal getRemainingAmountInDebt(SibsPaymentRequest p) {
        return p.getDebitEntriesSet().stream().map(d -> d.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add).add(p.getInstallmentsSet().stream().map(i -> i.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public Set<PaymentRequest> getPaymentRequestsOfAssociatedDebtsInPaidStateIncludingSelf() {
        HashSet<PaymentRequest> result = new HashSet<PaymentRequest>();
        this.getDebitEntriesSet().stream().flatMap(de -> de.getPaymentRequestsSet().stream()).filter(pr -> pr.isInPaidState()).collect(Collectors.toCollection(() -> result));
        this.getInstallmentsSet().stream().flatMap(de -> de.getPaymentRequestsSet().stream()).filter(pr -> pr.isInPaidState()).collect(Collectors.toCollection(() -> result));
        return result;
    }

    public static Stream<? extends PaymentRequest> findAll() {
        return FenixFramework.getDomainRoot().getPaymentRequestsSet().stream();
    }

    public static Stream<? extends PaymentRequest> findBySibsGatewayMerchantTransactionId(String merchantTransactionId) {
        return PaymentRequest.findAll().filter(p -> merchantTransactionId.equalsIgnoreCase(p.getMerchantTransactionId()));
    }

    public static Stream<? extends PaymentRequest> findBySibsGatewayTransactionId(String transactionId) {
        return PaymentRequest.findAll().filter(p -> transactionId.equalsIgnoreCase(p.getTransactionId()));
    }

    public static Optional<? extends PaymentRequest> findUniqueBySibsGatewayTransactionId(String transactionId) {
        return PaymentRequest.findBySibsGatewayTransactionId(transactionId).findAny();
    }

    public abstract String getUiDescription();
}

