/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.accesscontrol;

import java.util.stream.Stream;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControlConfiguration_Base;
import pt.ist.fenixframework.FenixFramework;

public class TreasuryAccessControlConfiguration
extends TreasuryAccessControlConfiguration_Base {
    public TreasuryAccessControlConfiguration() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        if (TreasuryAccessControlConfiguration.findAll().count() > 1L) {
            throw new RuntimeException("error.TreasuryAccessControlConfiguration.already.exists");
        }
        this.setAccessControlByAcademicAuthorizations(true);
        this.setAccessControlByBennuDynamicGroups(true);
        this.setAccessControlByStandardPermissions(true);
        this.setAccessControlByUnitBasedPermissions(true);
    }

    public void edit(boolean academicAuthorizations, boolean bennuDynamicGroups, boolean standardPermissions, boolean unitBasedPermissions) {
        this.setAccessControlByAcademicAuthorizations(academicAuthorizations);
        this.setAccessControlByBennuDynamicGroups(bennuDynamicGroups);
        this.setAccessControlByStandardPermissions(standardPermissions);
        this.setAccessControlByUnitBasedPermissions(unitBasedPermissions);
    }

    public static Stream<TreasuryAccessControlConfiguration> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryAccessControlConfigurationSet().stream();
    }

    public static TreasuryAccessControlConfiguration getInstance() {
        return FenixFramework.getDomainRoot().getTreasuryAccessControlConfigurationSet().stream().findFirst().orElse(null);
    }

    public static TreasuryAccessControlConfiguration create() {
        return new TreasuryAccessControlConfiguration();
    }

    public static TreasuryAccessControlConfiguration create(boolean academicAuthorizations, boolean bennuDynamicGroups, boolean standardPermissions, boolean unitBasedPermissions) {
        TreasuryAccessControlConfiguration configuration = new TreasuryAccessControlConfiguration();
        configuration.setAccessControlByAcademicAuthorizations(academicAuthorizations);
        configuration.setAccessControlByBennuDynamicGroups(bennuDynamicGroups);
        configuration.setAccessControlByStandardPermissions(standardPermissions);
        configuration.setAccessControlByUnitBasedPermissions(unitBasedPermissions);
        return configuration;
    }

    public static boolean isAccessControlByAcademicAuthorizations() {
        if (TreasuryAccessControlConfiguration.getInstance() != null) {
            return Boolean.TRUE.equals(TreasuryAccessControlConfiguration.getInstance().getAccessControlByAcademicAuthorizations());
        }
        return true;
    }

    public static boolean isAccessControlByBennuDynamicGroups() {
        if (TreasuryAccessControlConfiguration.getInstance() != null) {
            return Boolean.TRUE.equals(TreasuryAccessControlConfiguration.getInstance().getAccessControlByBennuDynamicGroups());
        }
        return true;
    }

    public static boolean isAccessControlByStandardPermissions() {
        if (TreasuryAccessControlConfiguration.getInstance() != null) {
            return Boolean.TRUE.equals(TreasuryAccessControlConfiguration.getInstance().getAccessControlByStandardPermissions());
        }
        return true;
    }

    public static boolean isAccessControlByUnitBasedPermissions() {
        if (TreasuryAccessControlConfiguration.getInstance() != null) {
            return Boolean.TRUE.equals(TreasuryAccessControlConfiguration.getInstance().getAccessControlByUnitBasedPermissions());
        }
        return true;
    }
}

