/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.CheckISO7064Mod97_10;

public class CheckDigitGenerator {
    public static String generateReferenceCodeWithCheckDigit(String entityCode, String referenceCode, BigDecimal amount) {
        String fullCode = entityCode + Strings.padStart((String)referenceCode, (int)7, (char)'0');
        String amountString = amount.setScale(2, RoundingMode.HALF_EVEN).toPlainString().replaceAll("\\.", "").replaceAll(",", "");
        amountString = Strings.padStart((String)amountString, (int)8, (char)'0');
        fullCode = fullCode + amountString;
        CheckISO7064Mod97_10 checkDigitGenerator = new CheckISO7064Mod97_10();
        String encodedDigits = checkDigitGenerator.encode(fullCode);
        return referenceCode + encodedDigits.charAt(encodedDigits.length() - 2) + encodedDigits.charAt(encodedDigits.length() - 1);
    }
}

