/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto.document.managepayments;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;

public class PaymentReferenceCodeBean
implements ITreasuryBean {
    private DigitalPaymentPlatform paymentCodePool;
    private List<TreasuryTupleDataSourceBean> paymentCodePoolDataSource;
    private String referenceCode;
    private LocalDate validFrom;
    private LocalDate validTo;
    private BigDecimal maxAmount;
    private BigDecimal minAmount;
    private BigDecimal paymentAmount;
    private boolean isPoolWithFixedAmount;
    private boolean isPoolVariableTimeWindow;
    private boolean useCustomPaymentAmount = false;
    private boolean usePaymentAmountWithInterests = false;
    private DebtAccount debtAccount;
    private List<DebitEntry> selectedDebitEntries = new ArrayList<DebitEntry>();
    private List<Installment> selectedInstallments = new ArrayList<Installment>();
    private String phoneNumberCountryPrefix;
    private String phoneNumber;

    public PaymentReferenceCodeBean() {
    }

    public PaymentReferenceCodeBean(DigitalPaymentPlatform digitalPaymentPlatform, DebtAccount debtAccount) {
        this();
        this.paymentCodePool = digitalPaymentPlatform;
        this.debtAccount = debtAccount;
        this.paymentCodePoolDataSource = DigitalPaymentPlatform.findForSibsPaymentCodeService(debtAccount.getFinantialInstitution()).filter(x -> x.isActive()).map(ISibsPaymentCodePoolService.class::cast).map(x -> new TreasuryTupleDataSourceBean(x.getExternalId(), String.format("[%s] - %s", x.getEntityReferenceCode(), x.getName()))).collect(Collectors.toList());
    }

    public BigDecimal getExtraAmount(DebitEntry debitEntry) {
        PaymentPenaltyEntryBean penaltyTax = PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(debitEntry, LocalDate.now());
        BigDecimal penaltyTaxAmount = penaltyTax != null ? penaltyTax.getSettledAmount() : BigDecimal.ZERO;
        return debitEntry.getOpenAmountWithInterests().add(penaltyTaxAmount);
    }

    public void updateAmountOnSelectedDebitEntries() {
        BigDecimal paymentAmountDebitEnries = this.selectedDebitEntries.stream().map(e -> this.isUsePaymentAmountWithInterests() ? this.getExtraAmount((DebitEntry)((Object)e)) : e.getOpenAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        BigDecimal paymentAmountInstallments = this.selectedInstallments.stream().map(e -> e.getOpenAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        this.paymentAmount = paymentAmountDebitEnries.add(paymentAmountInstallments);
    }

    public List<DebitEntry> getOpenDebitEntries() {
        return DebitEntry.find(this.debtAccount).filter(x -> !x.isAnnulled() && TreasuryConstants.isPositive(x.getOpenAmount())).filter(x -> !TreasuryDebtProcessMainService.isBlockingPaymentInFrontend((InvoiceEntry)((Object)((Object)x)))).sorted(DebitEntry.COMPARE_BY_EXTERNAL_ID).collect(Collectors.toList());
    }

    public List<Installment> getOpenInstallments() {
        return this.debtAccount.getActivePaymentPlansSet().stream().flatMap(i -> i.getSortedOpenInstallments().stream()).filter(i -> !this.someEntriesIsBlockedInFrontendPayment((Installment)((Object)i))).sorted(Installment.COMPARE_BY_DUEDATE).collect(Collectors.toList());
    }

    private boolean someEntriesIsBlockedInFrontendPayment(Installment installment) {
        return installment.getInstallmentEntriesSet().stream().anyMatch(e -> TreasuryDebtProcessMainService.isBlockingPaymentInFrontend((InvoiceEntry)((Object)((Object)((Object)e.getDebitEntry())))));
    }

    public DigitalPaymentPlatform getPaymentCodePool() {
        return this.paymentCodePool;
    }

    public void setPaymentCodePool(DigitalPaymentPlatform value) {
        this.paymentCodePool = value;
    }

    public List<TreasuryTupleDataSourceBean> getPaymentCodePoolDataSource() {
        return this.paymentCodePoolDataSource;
    }

    public void setPaymentCodePoolDataSource(List<PaymentCodePool> value) {
        this.paymentCodePoolDataSource = value.stream().map(x -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText("[" + x.getEntityReferenceCode() + "] - " + x.getName());
            return tuple;
        }).collect(Collectors.toList());
    }

    public String getReferenceCode() {
        return this.referenceCode;
    }

    public void setReferenceCode(String value) {
        this.referenceCode = value;
    }

    public LocalDate getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(LocalDate value) {
        this.validFrom = value;
    }

    public LocalDate getValidTo() {
        return this.validTo;
    }

    public void setValidTo(LocalDate value) {
        this.validTo = value;
    }

    public BigDecimal getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(BigDecimal value) {
        this.maxAmount = value;
    }

    public BigDecimal getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(BigDecimal value) {
        this.minAmount = value;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public boolean isUsePaymentAmountWithInterests() {
        return this.usePaymentAmountWithInterests;
    }

    public void setUsePaymentAmountWithInterests(boolean usePaymentAmountWithInterests) {
        this.usePaymentAmountWithInterests = usePaymentAmountWithInterests;
    }

    public boolean isPoolWithFixedAmount() {
        return this.isPoolWithFixedAmount;
    }

    public void setPoolWithFixedAmount(boolean poolWithFixedAmount) {
        this.isPoolWithFixedAmount = poolWithFixedAmount;
    }

    public boolean isPoolVariableTimeWindow() {
        return this.isPoolVariableTimeWindow;
    }

    public void setPoolVariableTimeWindow(boolean isPoolVariableTimeWindow) {
        this.isPoolVariableTimeWindow = isPoolVariableTimeWindow;
    }

    public boolean isUseCustomPaymentAmount() {
        return this.useCustomPaymentAmount;
    }

    public void setUseCustomPaymentAmount(boolean useCustomPaymentAmount) {
        this.useCustomPaymentAmount = useCustomPaymentAmount;
    }

    public List<DebitEntry> getSelectedDebitEntries() {
        return this.selectedDebitEntries;
    }

    public void setSelectedDebitEntries(List<DebitEntry> selectedDebitEntries) {
        this.selectedDebitEntries = selectedDebitEntries;
    }

    public String getPhoneNumberCountryPrefix() {
        return this.phoneNumberCountryPrefix;
    }

    public void setPhoneNumberCountryPrefix(String phoneNumberCountryPrefix) {
        this.phoneNumberCountryPrefix = phoneNumberCountryPrefix;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public List<Installment> getSelectedInstallments() {
        return this.selectedInstallments;
    }

    public void setSelectedInstallments(List<Installment> selectedInstallments) {
        this.selectedInstallments = selectedInstallments;
    }
}

