/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.requests;

import java.util.Comparator;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequestState;
import org.fenixedu.spaces.domain.occupation.requests.OccupationStateInstant_Base;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class OccupationStateInstant
extends OccupationStateInstant_Base {
    public static final Comparator<OccupationStateInstant> COMPARATOR_BY_INSTANT = new Comparator<OccupationStateInstant>(){

        @Override
        public int compare(OccupationStateInstant o1, OccupationStateInstant o2) {
            int o = o1.getInstant().compareTo((ReadableInstant)o2.getInstant());
            return o != 0 ? o : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    public OccupationStateInstant(OccupationRequest request, OccupationRequestState state, DateTime instant) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setRequest(request);
        this.setRequestState(state);
        this.setInstant(instant);
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getRequestState() != null && this.getInstant() != null;
    }

    public void setRequest(OccupationRequest request) {
        if (request == null) {
            throw new SpaceDomainException("error.OccupationStateInstant.empty.request", new String[0]);
        }
        super.setRequest(request);
    }

    public void setInstant(DateTime instant) {
        if (instant == null) {
            throw new SpaceDomainException("error.OccupationStateInstant.empty.instant", new String[0]);
        }
        super.setInstant(instant);
    }
}

