/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain;

import java.util.HashMap;
import java.util.List;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.BlueprintFile_Base;
import org.fenixedu.spaces.domain.Space;

public class BlueprintFile
extends BlueprintFile_Base {
    public BlueprintFile(String filename, byte[] content) {
        this.init(filename, filename, content);
    }

    public boolean isAccessible(User user) {
        return true;
    }

    public static class BlueprintPoint {
        private final int x;
        private final int y;

        public BlueprintPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class BlueprintTextRectangle {
        private final BlueprintPoint p1;
        private final BlueprintPoint p2;
        private final BlueprintPoint p3;
        private final BlueprintPoint p4;

        public BlueprintTextRectangle(String text, double x, double y, int fontSize) {
            double numberOfCharacters = text.length();
            double characterWidth = (double)fontSize / 1.6;
            double textSize = numberOfCharacters * characterWidth;
            this.p1 = new BlueprintPoint((int)x, (int)Math.round(y - (double)fontSize));
            this.p2 = new BlueprintPoint((int)x, (int)y);
            this.p3 = new BlueprintPoint((int)Math.round(x + textSize), (int)y);
            this.p4 = new BlueprintPoint((int)Math.round(x + textSize), (int)Math.round(y - (double)fontSize));
        }

        public BlueprintPoint getP1() {
            return this.p1;
        }

        public BlueprintPoint getP2() {
            return this.p2;
        }

        public BlueprintPoint getP3() {
            return this.p3;
        }

        public BlueprintPoint getP4() {
            return this.p4;
        }
    }

    public static class BlueprintTextRectangles
    extends HashMap<Space, List<BlueprintTextRectangle>> {
        private static final long serialVersionUID = 4137530994580538348L;
    }
}

