/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.requests;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.occupation.requests.OccupationComment;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequestState;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest_Base;
import org.fenixedu.spaces.domain.occupation.requests.OccupationStateInstant;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class OccupationRequest
extends OccupationRequest_Base {
    public static final Comparator<OccupationRequest> COMPARATOR_BY_IDENTIFICATION = new Comparator<OccupationRequest>(){

        @Override
        public int compare(OccupationRequest o1, OccupationRequest o2) {
            return o1.getIdentification().compareTo(o2.getIdentification());
        }
    };
    public static final Comparator<OccupationRequest> COMPARATOR_BY_INSTANT = new Comparator<OccupationRequest>(){

        @Override
        public int compare(OccupationRequest o1, OccupationRequest o2) {
            int o = o1.getInstant().compareTo((ReadableInstant)o2.getInstant());
            return o != 0 ? o : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };
    public static final Comparator<OccupationRequest> COMPARATOR_BY_MORE_RECENT_COMMENT_INSTANT = new Comparator<OccupationRequest>(){

        @Override
        public int compare(OccupationRequest o1, OccupationRequest o2) {
            int o = o1.getMoreRecentCommentInstant().compareTo((ReadableInstant)o2.getMoreRecentCommentInstant());
            return o != 0 ? o : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    public OccupationRequest(User requestor, String subject, Space campus, String description) {
        this.checkIfRequestAlreadyExists(requestor, subject, description);
        this.setRootDomainObject(Bennu.getInstance());
        this.setRequestor(requestor);
        DateTime now = new DateTime();
        this.setInstant(now);
        this.setCampus(campus);
        this.addStateInstants(new OccupationStateInstant(this, OccupationRequestState.NEW, now));
        this.addComment(new OccupationComment(this, subject, description, requestor, now));
        this.setTeacherReadComments(1);
        this.setEmployeeReadComments(0);
        this.setIdentification(this.getNextRequestIdentification());
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getInstant() != null && this.getIdentification() != null;
    }

    public Integer getNumberOfNewComments(User person) {
        if (person.equals((Object)this.getOwner())) {
            return this.getCommentSet().size() - this.getEmployeeReadComments();
        }
        if (person.equals((Object)this.getRequestor())) {
            return this.getCommentSet().size() - this.getTeacherReadComments();
        }
        return 0;
    }

    public DateTime getMoreRecentCommentInstant() {
        TreeSet<OccupationComment> result = new TreeSet<OccupationComment>(OccupationComment.COMPARATOR_BY_INSTANT);
        result.addAll(this.getCommentSet());
        return ((OccupationComment)((Object)result.last())).getInstant();
    }

    public void createNewTeacherOrEmployeeComment(String description, User commentOwner, DateTime instant) {
        new OccupationComment(this, this.getCommentSubject(), description, commentOwner, instant);
        if (commentOwner.equals((Object)this.getRequestor())) {
            this.setTeacherReadComments(this.getCommentSet().size());
        } else {
            this.setOwner(commentOwner);
            this.setEmployeeReadComments(this.getCommentSet().size());
        }
    }

    public void createNewTeacherCommentAndOpenRequest(String description, User commentOwner, DateTime instant) {
        this.openRequestWithoutAssociateOwner(instant);
        new OccupationComment(this, this.getCommentSubject(), description, commentOwner, instant);
        this.setTeacherReadComments(this.getCommentSet().size());
    }

    public void createNewEmployeeCommentAndCloseRequest(String description, User commentOwner, DateTime instant) {
        new OccupationComment(this, this.getCommentSubject(), description, commentOwner, instant);
        this.closeRequestWithoutAssociateOwner(instant);
        this.setOwner(commentOwner);
        this.setEmployeeReadComments(this.getCommentSet().size());
    }

    public void closeRequestAndAssociateOwnerOnlyForEmployees(DateTime instant, User person) {
        this.closeRequestWithoutAssociateOwner(instant);
        if (!this.getOwner().equals((Object)person)) {
            this.setEmployeeReadComments(0);
            this.setOwner(person);
        }
    }

    public void openRequestAndAssociateOwnerOnlyForEmployess(DateTime instant, User person) {
        this.openRequestWithoutAssociateOwner(instant);
        if (this.getOwner() == null || !this.getOwner().equals((Object)person)) {
            this.setEmployeeReadComments(0);
            this.setOwner(person);
        }
    }

    private void closeRequestWithoutAssociateOwner(DateTime instant) {
        if (!this.getCurrentState().equals((Object)OccupationRequestState.RESOLVED)) {
            this.addStateInstants(new OccupationStateInstant(this, OccupationRequestState.RESOLVED, instant));
        }
    }

    private void openRequestWithoutAssociateOwner(DateTime instant) {
        if (!this.getCurrentState().equals((Object)OccupationRequestState.OPEN)) {
            this.addStateInstants(new OccupationStateInstant(this, OccupationRequestState.OPEN, instant));
        }
    }

    public String getCommentSubject() {
        StringBuilder subject = new StringBuilder();
        subject.append("Re: ");
        OccupationComment firstComment = this.getFirstComment();
        if (firstComment != null) {
            subject.append(firstComment.getSubject());
        }
        return subject.toString();
    }

    public void setOwner(User owner) {
        if (owner == null || !owner.equals((Object)this.getRequestor())) {
            super.setOwner(owner);
        }
    }

    public void setIdentification(Integer identification) {
        if (identification == null) {
            throw new SpaceDomainException("error.OccupationRequest.empty.identification", new String[0]);
        }
        super.setIdentification(identification);
    }

    public void setRequestor(User requestor) {
        if (requestor == null) {
            throw new SpaceDomainException("error.OccupationRequest.empty.requestor", new String[0]);
        }
        super.setRequestor(requestor);
    }

    public void setInstant(DateTime instant) {
        if (instant == null) {
            throw new SpaceDomainException("error.OccupationRequest.empty.instant", new String[0]);
        }
        super.setInstant(instant);
    }

    public String getPresentationInstant() {
        return this.getInstant().toString("dd/MM/yyyy HH:mm");
    }

    public static List<OccupationRequest> getRequestsByTypeOrderByDate(OccupationRequestState state, Space campus) {
        return Bennu.getInstance().getOccupationRequestSet().stream().filter(r -> r.getCurrentState().equals((Object)state) && (r.getCampus() == null || r.getCampus().equals(campus))).sorted(COMPARATOR_BY_INSTANT.reversed()).collect(Collectors.toList());
    }

    public static OccupationRequest getRequestById(Integer requestID) {
        for (OccupationRequest request : Bennu.getInstance().getOccupationRequestSet()) {
            if (!request.getIdentification().equals(requestID)) continue;
            return request;
        }
        return null;
    }

    public static Set<OccupationRequest> getResolvedRequestsOrderByMoreRecentComment(Space campus) {
        TreeSet<OccupationRequest> result = new TreeSet<OccupationRequest>(COMPARATOR_BY_MORE_RECENT_COMMENT_INSTANT);
        for (OccupationRequest request : Bennu.getInstance().getOccupationRequestSet()) {
            if (!request.getCurrentState().equals((Object)OccupationRequestState.RESOLVED) || request.getCampus() != null && !request.getCampus().equals(campus)) continue;
            result.add(request);
        }
        return result;
    }

    public static Set<OccupationRequest> getRequestsByTypeAndDiferentOwnerOrderByDate(OccupationRequestState state, User owner, Space campus) {
        TreeSet<OccupationRequest> result = new TreeSet<OccupationRequest>(COMPARATOR_BY_INSTANT);
        for (OccupationRequest request : Bennu.getInstance().getOccupationRequestSet()) {
            if (!request.getCurrentState().equals((Object)state) || request.getOwner() != null && request.getOwner().equals((Object)owner) || request.getCampus() != null && !request.getCampus().equals(campus)) continue;
            result.add(request);
        }
        return result;
    }

    public OccupationComment getFirstComment() {
        for (OccupationComment comment : this.getCommentSet()) {
            if (!comment.getInstant().isEqual((ReadableInstant)this.getInstant())) continue;
            return comment;
        }
        return null;
    }

    public Set<OccupationComment> getCommentsWithoutFirstCommentOrderByDate() {
        TreeSet<OccupationComment> result = new TreeSet<OccupationComment>(OccupationComment.COMPARATOR_BY_INSTANT);
        for (OccupationComment comment : this.getCommentSet()) {
            if (comment.getInstant().isEqual((ReadableInstant)this.getInstant())) continue;
            result.add(comment);
        }
        return result;
    }

    public String getSubject() {
        OccupationComment firstComment = this.getFirstComment();
        String content = firstComment != null ? firstComment.getSubject() : null;
        return content == null || content.isEmpty() ? this.getIdentification().toString() : content;
    }

    public String getDescription() {
        OccupationComment firstComment = this.getFirstComment();
        String description = firstComment == null ? null : firstComment.getDescription();
        String content = description == null ? null : description;
        return content == null ? this.getExternalId() : content;
    }

    public OccupationRequestState getCurrentState() {
        TreeSet<OccupationStateInstant> result = new TreeSet<OccupationStateInstant>(OccupationStateInstant.COMPARATOR_BY_INSTANT);
        result.addAll(this.getStateInstantsSet());
        return ((OccupationStateInstant)((Object)result.last())).getRequestState();
    }

    public OccupationRequestState getState(DateTime instanTime) {
        if (instanTime == null) {
            return this.getCurrentState();
        }
        for (OccupationStateInstant stateInstant : this.getStateInstantsSet()) {
            if (!stateInstant.getInstant().isEqual((ReadableInstant)instanTime)) continue;
            return stateInstant.getRequestState();
        }
        return null;
    }

    private Integer getNextRequestIdentification() {
        TreeSet<OccupationRequest> result = new TreeSet<OccupationRequest>(COMPARATOR_BY_IDENTIFICATION);
        Set requests = Bennu.getInstance().getOccupationRequestSet();
        for (OccupationRequest request : requests) {
            if (request.equals((Object)this)) continue;
            result.add(request);
        }
        return result.isEmpty() ? 1 : ((OccupationRequest)((Object)result.last())).getIdentification() + 1;
    }

    private void checkIfRequestAlreadyExists(User requestor, String subject, String description) {
        Set requests = requestor.getOccupationRequestSet();
        for (OccupationRequest request : requests) {
            OccupationComment firstComment = request.getFirstComment();
            if (firstComment == null || firstComment.getSubject() == null || firstComment.getSubject().compareTo(subject) != 0 || firstComment.getDescription() == null || firstComment.getDescription().compareTo(description) != 0) continue;
            throw new SpaceDomainException("error.OccupationRequest.request.already.exists", new String[0]);
        }
    }
}

