/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.MetadataSpec;
import org.fenixedu.spaces.domain.SpaceClassification$callable$delete;
import org.fenixedu.spaces.domain.SpaceClassification_Base;
import org.fenixedu.spaces.ui.SpaceClassificationBean;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SpaceClassification
extends SpaceClassification_Base {
    public static final Comparator<SpaceClassification> ABSOLUTE_CODE_COMPARATOR;
    public static final Advice advice$delete;

    public SpaceClassification(String code, LocalizedString name, SpaceClassification parent, JsonElement metadataSpec) {
        this(code, name, parent, metadataSpec, true);
    }

    public SpaceClassification(String code, LocalizedString name, SpaceClassification parent, JsonElement metadataSpec, boolean isAllocatable) {
        this.setCode(code);
        this.setName(name);
        this.setParent(parent);
        this.setIsAllocatable(isAllocatable);
        if (parent == null) {
            this.setBennu(Bennu.getInstance());
        }
        this.setMetadataSpec(metadataSpec);
    }

    public SpaceClassification(String code, LocalizedString name, SpaceClassification parent) {
        this(code, name, parent, (JsonElement)new JsonArray());
    }

    public boolean isAllocatable() {
        return this.getIsAllocatable();
    }

    public SpaceClassification(String code, LocalizedString name) {
        this(code, name, null);
    }

    public static SpaceClassification get(String code) {
        String parentCode = null;
        String childCode = null;
        if (code.indexOf(".") != -1) {
            String[] subCodes = code.split("\\.");
            parentCode = subCodes[0];
            childCode = subCodes[1];
        } else {
            parentCode = code;
        }
        for (SpaceClassification classification : Bennu.getInstance().getRootClassificationSet()) {
            if (!classification.getCode().equals(parentCode)) continue;
            if (childCode != null) {
                return classification.getChild(childCode);
            }
            return classification;
        }
        return null;
    }

    private SpaceClassification getChild(String code) {
        for (SpaceClassification child : this.getChildrenSet()) {
            if (!child.getCode().equals(code)) continue;
            return child;
        }
        return null;
    }

    public String getAbsoluteCode() {
        return this.getPath().stream().filter(c -> !c.getCode().isEmpty()).map(c -> c.getCode()).collect(Collectors.joining("."));
    }

    private List<SpaceClassification> getPath() {
        ArrayList<SpaceClassification> path = new ArrayList<SpaceClassification>();
        for (SpaceClassification parent = this; parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    private void dump(List<SpaceClassification> classifications) {
        classifications.add(this);
        for (SpaceClassification classification : this.getChildrenSet()) {
            classification.dump(classifications);
        }
    }

    public static List<SpaceClassification> all() {
        ArrayList<SpaceClassification> classifications = new ArrayList<SpaceClassification>();
        for (SpaceClassification classification : Bennu.getInstance().getRootClassificationSet()) {
            classification.dump(classifications);
        }
        return classifications.stream().sorted(ABSOLUTE_CODE_COMPARATOR).collect(Collectors.toList());
    }

    public List<SpaceClassification> getAllChildren() {
        ArrayList<SpaceClassification> classifications = new ArrayList<SpaceClassification>();
        for (SpaceClassification classification : this.getChildrenSet()) {
            classification.dump(classifications);
        }
        return classifications.stream().sorted(ABSOLUTE_CODE_COMPARATOR).collect(Collectors.toList());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new SpaceClassification$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SpaceClassification this_) {
        if (!this_.getInformationsSet().isEmpty()) {
            throw new DeleteSpaceClassificationException(this_.getName().getContent());
        }
        this_.getChildrenSet().forEach(m -> m.delete());
        this_.setParent(null);
        this_.setBennu(null);
        this_.deleteDomainObject();
    }

    public Optional<JsonElement> getMetadataSpecJson(String field) {
        for (JsonElement je : this.getMetadataSpec().getAsJsonArray()) {
            JsonObject job = je.getAsJsonObject();
            if (!job.get("name").getAsString().equals(field)) continue;
            return Optional.of(je);
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<MetadataSpec> getMetadataSpec(String field) {
        for (MetadataSpec spec : this.getMetadataSpecs()) {
            if (!spec.getName().equals(field)) continue;
            return Optional.of(spec);
        }
        return Optional.empty();
    }

    @Deprecated
    public Collection<MetadataSpec> getMetadataSpecs() {
        ArrayList<MetadataSpec> specs = new ArrayList<MetadataSpec>();
        for (JsonElement metadataSpec : this.getMetadataSpec().getAsJsonArray()) {
            specs.add(new MetadataSpec(metadataSpec));
        }
        return specs;
    }

    public void setMetadataSpec(JsonElement metadataSpec) {
        if (metadataSpec == null) {
            super.setMetadataSpec((JsonElement)new JsonArray());
        }
        super.setMetadataSpec(metadataSpec);
        JsonElement toUpdate = this.computeUpdate(metadataSpec);
        for (SpaceClassification classification : this.getChildrenSet()) {
            classification.updateAndPropagate(toUpdate);
        }
    }

    private JsonElement filterInherited(JsonElement currentMetadata) {
        JsonArray current = currentMetadata.getAsJsonArray();
        JsonArray newCurrent = new JsonArray();
        for (JsonElement spec : current) {
            JsonObject specObj = spec.getAsJsonObject();
            if (specObj.get("inherited") != null && !specObj.get("inherited").isJsonNull() && specObj.get("inherited").getAsBoolean()) continue;
            newCurrent.add(spec);
        }
        return newCurrent;
    }

    private JsonElement computeUpdate(JsonElement metadataSpec) {
        JsonElement toInherit = this.filterInherited(metadataSpec);
        toInherit = new JsonParser().parse(toInherit.toString());
        for (JsonElement ti : toInherit.getAsJsonArray()) {
            JsonObject job = ti.getAsJsonObject();
            job.addProperty("inherited", Boolean.valueOf(true));
        }
        return toInherit;
    }

    private void updateAndPropagate(JsonElement toUpdate) {
        this.updateClassification(toUpdate);
        for (SpaceClassification classification : this.getChildrenSet()) {
            classification.updateAndPropagate(toUpdate);
        }
    }

    private void updateClassification(JsonElement toUpdate) {
        JsonObject specObj;
        JsonElement metadataSpec = this.getMetadataSpec();
        JsonArray newSpec = new JsonArray();
        HashMap<String, JsonObject> fields = new HashMap<String, JsonObject>();
        for (JsonElement spec : metadataSpec.getAsJsonArray()) {
            specObj = spec.getAsJsonObject();
            fields.put(specObj.get("name").getAsString(), specObj);
        }
        for (JsonElement spec : toUpdate.getAsJsonArray()) {
            specObj = spec.getAsJsonObject();
            fields.put(specObj.get("name").getAsString(), specObj);
        }
        for (JsonElement spec : fields.values()) {
            newSpec.add(spec);
        }
        super.setMetadataSpec((JsonElement)newSpec);
    }

    public void setMetadataSpecs(Collection<MetadataSpec> specs) {
        JsonArray specsJson = new JsonArray();
        for (MetadataSpec spec : specs) {
            specsJson.add(spec.toJson());
        }
        this.setMetadataSpec((JsonElement)specsJson);
    }

    public SpaceClassificationBean getBean() {
        return new SpaceClassificationBean(this);
    }

    @Deprecated
    public static SpaceClassification getCampusClassification() {
        SpaceClassification byName = SpaceClassification.getByName("Campus");
        if (byName == null) {
            throw new UnsupportedOperationException("Campus type not defined.");
        }
        return byName;
    }

    private boolean hasMatchByName(String needle) {
        LocalizedString name = this.getName();
        for (Locale locale : name.getLocales()) {
            if (!needle.equals(name.getContent(locale))) continue;
            return true;
        }
        return false;
    }

    private SpaceClassification findByName(String needle) {
        return this.hasMatchByName(needle) ? this : SpaceClassification.findByName(needle, this.getChildrenSet());
    }

    private static SpaceClassification findByName(String needle, Collection<SpaceClassification> classifications) {
        for (SpaceClassification classification : classifications) {
            SpaceClassification result = classification.findByName(needle);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isRootClassification() {
        return Bennu.getInstance().getRootClassificationSet().contains((Object)this);
    }

    public static SpaceClassification getByName(String needle) {
        return SpaceClassification.findByName(needle, Bennu.getInstance().getRootClassificationSet());
    }

    public static SpaceClassification getRootClassification() {
        return (SpaceClassification)((Object)Bennu.getInstance().getRootClassificationSet().iterator().next());
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        ABSOLUTE_CODE_COMPARATOR = new Comparator<SpaceClassification>(){

            private int compareIntString(String o1, String o2) {
                try {
                    Integer o1AbsCode = Integer.parseInt(o1);
                    Integer o2AbsCode = Integer.parseInt(o2);
                    return o1AbsCode.compareTo(o2AbsCode);
                }
                catch (NumberFormatException nfe) {
                    return o1.compareTo(o2);
                }
            }

            @Override
            public int compare(SpaceClassification o1, SpaceClassification o2) {
                String[] tokens1 = o1.getAbsoluteCode().split("[.]");
                String[] tokens2 = o2.getAbsoluteCode().split("[.]");
                for (int i = 0; i < Math.min(tokens1.length, tokens2.length); ++i) {
                    int result = this.compareIntString(tokens1[i], tokens2[i]);
                    if (result == 0) continue;
                    return result;
                }
                return tokens1.length - tokens2.length;
            }
        };
    }

    private static class DeleteSpaceClassificationException
    extends DomainException {
        protected DeleteSpaceClassificationException(String name) {
            super(Response.Status.INTERNAL_SERVER_ERROR, "resources/FenixEduSpacesResources", "label.cannotDeleteSpaceClassification", new String[]{name});
        }
    }
}

