/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.SpaceClassification;

public class SpaceClassificationBean {
    private final JsonElement metadataSpec;
    private final LocalizedString localizedName;
    private String parent;
    private String code;
    private boolean isAllocatable;
    private String warningMessage;

    public SpaceClassificationBean(SpaceClassification classification) {
        this.parent = classification.getParent() == null ? "" : classification.getParent().getExternalId();
        this.code = classification.getCode();
        this.localizedName = classification.getName();
        this.metadataSpec = classification.getMetadataSpec();
        this.isAllocatable = classification.isAllocatable();
    }

    public SpaceClassificationBean(String json) {
        JsonObject classificationJson = new JsonParser().parse(json).getAsJsonObject();
        this.localizedName = LocalizedString.fromJson((JsonElement)classificationJson.get("name"));
        this.metadataSpec = classificationJson.get("metadata");
        this.parent = classificationJson.get("parent").getAsString();
        this.code = classificationJson.get("code").getAsString();
        this.isAllocatable = classificationJson.get("isAllocatable").getAsBoolean();
    }

    public SpaceClassificationBean() {
        this.localizedName = new LocalizedString();
        this.metadataSpec = new JsonArray();
        this.parent = SpaceClassification.getRootClassification().getExternalId();
        this.code = "";
        this.isAllocatable = true;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public JsonElement getMetadataSpec() {
        return this.metadataSpec;
    }

    public LocalizedString getLocalizedName() {
        return this.localizedName;
    }

    public boolean getIsAllocatable() {
        return this.isAllocatable;
    }

    public void setIsAllocatable(boolean isAllocatable) {
        this.isAllocatable = isAllocatable;
    }
}

