/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.config;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.occupation.config.OccupationConfig;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Interval;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;

public class ExplicitConfigWithSettings
extends OccupationConfig {
    private final DateTime start;
    private final DateTime end;
    private final Boolean allDay;
    private final Frequency frequency;
    private final Integer repeatsevery;
    private final List<Integer> weekdays;
    private final MonthlyType monthlyType;
    private final List<Interval> intervals;

    public ExplicitConfigWithSettings(DateTime start, DateTime end, Boolean allDay, List<Interval> intervals) {
        this(start, end, allDay, null, Frequency.NEVER, null, null, intervals);
    }

    public ExplicitConfigWithSettings(DateTime start, DateTime end, Boolean allDay, Frequency frequency, Integer repeatsEvery, List<Interval> intervals) {
        this(start, end, allDay, repeatsEvery, frequency, null, null, intervals);
    }

    public ExplicitConfigWithSettings(DateTime start, DateTime end, Boolean allDay, Integer repeatsEvery, Frequency frequency, List<Integer> weekdays, MonthlyType monthlyType, List<Interval> intervals) {
        this.start = start;
        this.end = end;
        this.allDay = allDay;
        this.repeatsevery = repeatsEvery;
        this.frequency = frequency;
        this.weekdays = weekdays;
        this.monthlyType = monthlyType;
        this.intervals = intervals;
    }

    @Override
    public DateTime getStart() {
        if (this.start != null) {
            return this.start;
        }
        return super.getStart();
    }

    @Override
    public DateTime getEnd() {
        if (this.end != null) {
            return this.end;
        }
        return super.getEnd();
    }

    public Boolean getAllDay() {
        return this.allDay;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public Integer getRepeatsevery() {
        return this.repeatsevery;
    }

    public List<Integer> getWeekdays() {
        return this.weekdays;
    }

    public MonthlyType getMonthlyType() {
        return this.monthlyType;
    }

    @Override
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public String getSummary() {
        String beginDate = this.getStart().toString("dd/MM/yyyy");
        String endDate = this.getEnd().toString("dd/MM/yyyy");
        String beginTime = this.getStart().toString("HH:mm:ss");
        String endTime = this.getEnd().toString("HH:mm:ss");
        char frequencySymbol = BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)("label.frequency." + this.getFrequency().name()), (String[])new String[0]).charAt(0);
        if (Frequency.NEVER.equals((Object)this.getFrequency())) {
            return String.format("%s %s - %s %s", beginDate, beginTime, endDate, endTime);
        }
        return String.format("[%s] [%s - %s] (%s - %s)", Character.valueOf(frequencySymbol), beginDate, endDate, beginTime, endTime);
    }

    @Override
    public String getExtendedSummary() {
        if (this.getFrequency() != null && !Frequency.NEVER.equals((Object)this.getFrequency())) {
            String frequency = BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)("label.frequency." + this.getFrequency().name()), (String[])new String[0]);
            String frequencyUnit = BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)("label.frequency.unit." + this.getFrequency().name()), (String[])new String[0]);
            String repeats = BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"label.occupation.config.summary", (String[])new String[]{this.getRepeatsevery().toString(), frequencyUnit});
            if (Frequency.MONTHLY.equals((Object)this.getFrequency())) {
                repeats = this.getMonthlySummary();
            }
            if (Frequency.WEEKLY.equals((Object)this.getFrequency())) {
                String weekdays = this.getWeekdays().stream().map(w -> new Partial(DateTimeFieldType.dayOfWeek(), w.intValue())).map(p -> p.toString("E")).collect(Collectors.joining(","));
                repeats = Stream.of(repeats, BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"label.occupation.config.summary.weekdays", (String[])new String[]{weekdays})).collect(Collectors.joining(" "));
            }
            return String.format("%s %s", frequency, repeats);
        }
        return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"label.occupation.config.no.repeat", (String[])new String[0]);
    }

    private String getMonthlySummary() {
        switch (this.getMonthlyType()) {
            case DAY_OF_MONTH: {
                return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"label.occupation.config.summary.DAY_OF_MONTH", (String[])new String[]{new Integer(this.getStart().getDayOfMonth()).toString()});
            }
            case DAY_OF_WEEK: {
                return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"label.occupation.config.summary.DAY_OF_WEEK", (String[])new String[]{ExplicitConfigWithSettings.getNthDayOfTheWeekLabel(this.getStart()), this.getStart().toString("EEEE")});
            }
        }
        return null;
    }

    private static int getNthDayOfWeek(DateTime when) {
        DateTime checkpoint = when;
        int whenDayOfWeek = checkpoint.getDayOfWeek();
        int month = checkpoint.getMonthOfYear();
        checkpoint = checkpoint.withDayOfMonth(1);
        checkpoint = checkpoint.withDayOfWeek(whenDayOfWeek);
        checkpoint = checkpoint.plusWeeks(month - checkpoint.getDayOfMonth());
        int i = 0;
        while (checkpoint.getMonthOfYear() == month && !checkpoint.isEqual((ReadableInstant)when)) {
            checkpoint = checkpoint.plusWeeks(1);
            ++i;
        }
        return i;
    }

    private static String getNthDayOfTheWeekLabel(DateTime when) {
        int nth = ExplicitConfigWithSettings.getNthDayOfWeek(when);
        if (nth > 3) {
            return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)"label.ordinal.numbers.last", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)("label.ordinal.numbers." + nth), (String[])new String[0]);
    }

    public static enum Frequency {
        NEVER,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }

    public static enum MonthlyType {
        DAY_OF_MONTH,
        DAY_OF_WEEK;

    }
}

