/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.spaces.domain.BlueprintFile;
import org.fenixedu.spaces.domain.MetadataSpec;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.domain.submission.SpacePhoto;
import org.joda.time.DateTime;

public class InformationBean {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private Integer allocatableCapacity;
    private String blueprintNumber;
    private BigDecimal area;
    private String name;
    private String identification;
    private DateTime validFrom;
    private DateTime validUntil;
    private SpaceClassification classification;
    private Map<String, String> metadata;
    private String externalId;
    private BlueprintFile blueprint;
    private Set<SpacePhoto> spacePhotoSet;
    private User user;
    private static Gson gson = new Gson();

    public InformationBean() {
        this.validFrom = new DateTime();
        this.metadata = new HashMap<String, String>();
        this.user = Authenticate.getUser() != null ? Authenticate.getUser() : null;
    }

    @Deprecated
    public InformationBean(String externalId, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, DateTime validFrom, DateTime validUntil, JsonElement metadata, SpaceClassification classification, BlueprintFile blueprint, User user) {
        this(externalId, allocatableCapacity, blueprintNumber, area, name, identification, validFrom, validUntil, metadata, classification, blueprint, null, user);
    }

    public InformationBean(String externalId, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, DateTime validFrom, DateTime validUntil, JsonElement metadata, SpaceClassification classification, BlueprintFile blueprint, Set<SpacePhoto> spacePhotoSet, User user) {
        this.externalId = externalId;
        this.allocatableCapacity = allocatableCapacity;
        this.blueprintNumber = blueprintNumber;
        this.area = area;
        this.name = name;
        this.identification = identification;
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        this.classification = classification;
        this.blueprint = blueprint;
        this.spacePhotoSet = spacePhotoSet;
        this.user = user;
        this.setMetadata(metadata);
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Integer getAllocatableCapacity() {
        return this.allocatableCapacity;
    }

    public void setAllocatableCapacity(Integer allocatableCapacity) {
        this.allocatableCapacity = allocatableCapacity;
    }

    public String getBlueprintNumber() {
        return this.blueprintNumber;
    }

    public void setBlueprintNumber(String blueprintNumber) {
        this.blueprintNumber = blueprintNumber;
    }

    public BigDecimal getArea() {
        return this.area;
    }

    public void setArea(BigDecimal area) {
        this.area = area;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public DateTime getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(DateTime validFrom) {
        this.validFrom = validFrom;
    }

    public DateTime getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(DateTime validUntil) {
        this.validUntil = validUntil;
    }

    public SpaceClassification getClassification() {
        return this.classification;
    }

    public void setClassification(SpaceClassification classification) {
        this.classification = classification;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JsonElement metadata) {
        HashMap<String, String> meta = new HashMap<String, String>();
        if (metadata != null) {
            JsonObject json = metadata.getAsJsonObject();
            for (Map.Entry entry : json.entrySet()) {
                meta.put((String)entry.getKey(), ((JsonElement)entry.getValue()).isJsonNull() ? null : ((JsonElement)entry.getValue()).getAsString());
            }
        }
        this.setMetadata(meta);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    private static JsonElement convert(Class<?> type, String value) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return new JsonPrimitive(value);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return new JsonPrimitive(Boolean.valueOf(Boolean.parseBoolean(value)));
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new JsonPrimitive((Number)Integer.parseInt(value));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new JsonPrimitive((Number)new BigDecimal(value));
        }
        return new JsonPrimitive(value);
    }

    public JsonElement getRawMetadata() {
        JsonObject json = new JsonObject();
        if (this.classification != null) {
            for (MetadataSpec spec : this.classification.getMetadataSpecs()) {
                if (spec.isInactive()) continue;
                String name = spec.getName();
                if (this.metadata.containsKey(name)) {
                    json.add(name, InformationBean.convert(spec.getType(), this.getValue(name)));
                    continue;
                }
                if (!spec.isRequired()) continue;
                json.add(name, InformationBean.convert(spec.getType(), spec.getDefaultValue()));
            }
        }
        return json;
    }

    private String getValue(String name) {
        String value = this.metadata.get(name);
        return value == null ? null : value.toString();
    }

    public void setBlueprint(BlueprintFile file) {
        this.blueprint = file;
    }

    public BlueprintFile getBlueprint() {
        return this.blueprint;
    }

    public byte[] getBlueprintContent() {
        return null;
    }

    public void setSpacePhotoSet(Set<SpacePhoto> files) {
        this.spacePhotoSet = files;
    }

    public Set<SpacePhoto> getSpacePhotoSet() {
        return this.spacePhotoSet;
    }

    public byte[] getSpacePhotoContent() {
        return null;
    }
}

