/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.submission;

import java.util.Comparator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.submission.SpacePhoto;
import org.fenixedu.spaces.domain.submission.SpacePhotoSubmission_Base;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SpacePhotoSubmission
extends SpacePhotoSubmission_Base {
    public static final Comparator<SpacePhotoSubmission> COMPARATOR_BY_INSTANT = new Comparator<SpacePhotoSubmission>(){

        @Override
        public int compare(SpacePhotoSubmission ps1, SpacePhotoSubmission ps2) {
            int ps = ps1.getCreated().compareTo((ReadableInstant)ps2.getCreated());
            return ps != 0 ? ps : ps1.getExternalId().compareTo(ps2.getExternalId());
        }
    };
    public static final Comparator<SpacePhotoSubmission> COMPARATOR_BY_MODIFIED = new Comparator<SpacePhotoSubmission>(){

        @Override
        public int compare(SpacePhotoSubmission ps1, SpacePhotoSubmission ps2) {
            int ps = ps1.getModified().compareTo((ReadableInstant)ps2.getModified());
            return ps != 0 ? ps : ps1.getExternalId().compareTo(ps2.getExternalId());
        }
    };

    public SpacePhotoSubmission(Space space, User submitor, SpacePhoto photo) {
        this.setSpace(space);
        this.setSpacePending(space);
        DateTime init = new DateTime();
        this.setCreated(init);
        this.setModified(init);
        this.setSubmitor(submitor);
        this.setPhoto(photo);
    }

    public void setSubmitor(User submitor) {
        if (submitor != null) {
            super.setSubmitor(submitor);
        }
    }

    public void setReviewer(User reviewer) {
        if (reviewer != null) {
            super.setReviewer(reviewer);
        }
    }

    public void setCreated(DateTime instant) {
        if (instant == null) {
            throw new SpaceDomainException("error.OccupationRequest.empty.instant", new String[0]);
        }
        super.setCreated(instant);
    }

    public void setModified(DateTime instant) {
        if (instant == null) {
            throw new SpaceDomainException("error.OccupationRequest.empty.instant", new String[0]);
        }
        super.setModified(instant);
    }

    public boolean isPending() {
        return this.getSpacePending() != null;
    }

    public boolean isRejected() {
        return this.getSpaceArchived() != null && this.getRejectionMessage() != null;
    }

    public boolean isAccepted() {
        return this.getSpacePending() == null && (this.getSpaceArchived() == null || this.getSpaceArchived() != null && this.getRejectionMessage() == null);
    }

    public void delete() {
        this.getPhoto().delete();
        super.setSubmitor(null);
        super.setSpace(null);
        super.setSpacePending(null);
        super.deleteDomainObject();
    }
}

