/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.services;

import com.google.common.io.Files;
import com.iver.cit.jdwglib.dwg.DwgFile;
import com.iver.cit.jdwglib.dwg.DwgObject;
import com.iver.cit.jdwglib.dwg.objects.DwgArc;
import com.iver.cit.jdwglib.dwg.objects.DwgAttdef;
import com.iver.cit.jdwglib.dwg.objects.DwgAttrib;
import com.iver.cit.jdwglib.dwg.objects.DwgBlock;
import com.iver.cit.jdwglib.dwg.objects.DwgBlockHeader;
import com.iver.cit.jdwglib.dwg.objects.DwgCircle;
import com.iver.cit.jdwglib.dwg.objects.DwgEllipse;
import com.iver.cit.jdwglib.dwg.objects.DwgEndblk;
import com.iver.cit.jdwglib.dwg.objects.DwgInsert;
import com.iver.cit.jdwglib.dwg.objects.DwgLayer;
import com.iver.cit.jdwglib.dwg.objects.DwgLine;
import com.iver.cit.jdwglib.dwg.objects.DwgLwPolyline;
import com.iver.cit.jdwglib.dwg.objects.DwgMText;
import com.iver.cit.jdwglib.dwg.objects.DwgPoint;
import com.iver.cit.jdwglib.dwg.objects.DwgPolyline2D;
import com.iver.cit.jdwglib.dwg.objects.DwgSeqend;
import com.iver.cit.jdwglib.dwg.objects.DwgSolid;
import com.iver.cit.jdwglib.dwg.objects.DwgText;
import com.iver.cit.jdwglib.dwg.objects.DwgVertex2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.UUID;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.fenixedu.bennu.FenixEduSpaceConfiguration;

public class DWGProcessor {
    private static final String FONT_NAME = "Bitstream Vera Sans Mono";
    protected final int scaleRatio;
    protected final int fontSize;
    protected final int padding;
    protected final int xAxisOffset;
    protected final int yAxisOffset;
    protected final BigDecimal scalePercentage;
    protected BigDecimal HUNDRED_PERCENTAGE = BigDecimal.valueOf(100L);
    private static final String TEMPORARY_FILE_GLOBAL_UNIQUE_NAME_PREFIX = UUID.randomUUID().toString();

    public DWGProcessor() throws IOException {
        this(BigDecimal.valueOf(100L));
    }

    public DWGProcessor(BigDecimal percentageOfScale) throws IOException {
        this.scalePercentage = percentageOfScale == null || percentageOfScale.compareTo(this.HUNDRED_PERCENTAGE) == 1 ? this.HUNDRED_PERCENTAGE : percentageOfScale;
        String scaleRatioString = FenixEduSpaceConfiguration.getConfiguration().scaleRatio();
        String fontSizeString = FenixEduSpaceConfiguration.getConfiguration().fontSize();
        String paddingString = FenixEduSpaceConfiguration.getConfiguration().padding();
        String xAxisOffsetString = FenixEduSpaceConfiguration.getConfiguration().xAxisOffset();
        String yAxisOffsetString = FenixEduSpaceConfiguration.getConfiguration().yAxisOffset();
        Double scaleDouble = Double.valueOf(scaleRatioString);
        this.scaleRatio = (int)this.scalePercentage.divide(BigDecimal.valueOf(100L)).multiply(BigDecimal.valueOf(scaleDouble)).doubleValue();
        this.fontSize = (int)((double)this.scaleRatio * Double.valueOf(fontSizeString));
        this.padding = (int)((double)this.scaleRatio * Double.valueOf(paddingString));
        this.xAxisOffset = (int)((double)this.scaleRatio * Double.valueOf(xAxisOffsetString));
        this.yAxisOffset = (int)((double)this.scaleRatio * Double.valueOf(yAxisOffsetString));
    }

    protected static String constructOutputFilename(File inputFile, String outputDirname) {
        String simplename = inputFile.getName();
        return outputDirname + "/" + simplename.substring(0, simplename.length() - 3) + "jpg";
    }

    public void generateJPEGImage(byte[] bytes, OutputStream outputStream) throws IOException {
        File file = File.createTempFile(TEMPORARY_FILE_GLOBAL_UNIQUE_NAME_PREFIX, "");
        file.deleteOnExit();
        Files.write((byte[])bytes, (File)file);
        this.generateJPEGImage(file.getAbsolutePath(), outputStream);
    }

    public void generateJPEGImage(String filename, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.process(filename, outputStream);
        ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        outputStream.close();
    }

    protected BufferedImage process(String filename, OutputStream outputStream) throws IOException {
        DwgFile dwgFile = this.readDwgFile(filename);
        Vector dwgObjects = dwgFile.getDwgObjects();
        ReferenceConverter referenceConverter = new ReferenceConverter(dwgObjects, this.scaleRatio);
        BufferedImage bufferedImage = new BufferedImage((int)referenceConverter.convX(referenceConverter.maxX), (int)referenceConverter.convY(referenceConverter.minY), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(new Font(FONT_NAME, 0, this.fontSize));
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setColor(Color.BLACK);
        graphics2D.clearRect(0, 0, (int)referenceConverter.convX(referenceConverter.maxX), (int)referenceConverter.convY(referenceConverter.minY));
        for (DwgObject dwgObject : dwgObjects) {
            this.drawObject(referenceConverter, graphics2D, dwgObject);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private void drawObject(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgObject dwgObject) {
        if (dwgObject instanceof DwgLine) {
            DwgLine dwgLine = (DwgLine)dwgObject;
            this.drawLine(referenceConverter, graphics2D, dwgLine);
        } else if (dwgObject instanceof DwgArc) {
            DwgArc dwgArc = (DwgArc)dwgObject;
            this.drawArc(referenceConverter, graphics2D, dwgArc);
        } else if (dwgObject instanceof DwgText) {
            DwgText dwgText = (DwgText)dwgObject;
            this.drawText(referenceConverter, graphics2D, dwgText);
        } else if (dwgObject instanceof DwgMText) {
            DwgMText dwgMText = (DwgMText)dwgObject;
            this.drawText(referenceConverter, graphics2D, dwgMText);
        } else if (dwgObject instanceof DwgLwPolyline) {
            DwgLwPolyline dwgLwPolyline = (DwgLwPolyline)dwgObject;
            this.drawPolygonLine(referenceConverter, graphics2D, dwgLwPolyline);
        } else if (dwgObject instanceof DwgEllipse) {
            DwgEllipse dwgEllipse = (DwgEllipse)dwgObject;
            this.drawEllipse(referenceConverter, graphics2D, dwgEllipse);
        } else if (dwgObject instanceof DwgCircle) {
            DwgCircle dwgCircle = (DwgCircle)dwgObject;
            this.drawCircle(referenceConverter, graphics2D, dwgCircle);
        }
    }

    protected void drawCircle(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgCircle dwgCircle) {
        double radius = dwgCircle.getRadius();
        double xc = dwgCircle.getCenter()[0];
        double yc = dwgCircle.getCenter()[1];
        boolean startAngle = false;
        int endAngle = 360;
        this.graphics2DDrawArc(referenceConverter, graphics2D, radius, xc, yc, 0, 360);
    }

    protected void drawEllipse(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgEllipse dwgEllipse) {
        int endAngle;
        int startAngle;
        double width = ReferenceConverter.getEllipseWidth(dwgEllipse);
        double heigth = ReferenceConverter.getEllipseHeigth(dwgEllipse);
        double xc = dwgEllipse.getCenter()[0];
        double yc = dwgEllipse.getCenter()[1];
        double ti = dwgEllipse.getInitAngle();
        double tf = dwgEllipse.getEndAngle();
        if (tf > ti) {
            startAngle = this.calcDegreeAngle(ti);
            endAngle = this.calcDegreeAngle(Math.abs(Math.abs(tf) - Math.abs(ti)));
        } else {
            startAngle = this.calcDegreeAngle(tf);
            endAngle = -1 * this.calcDegreeAngle(Math.abs(Math.abs(ti) - Math.abs(tf + Math.PI * 2)));
        }
        int xmax = this.convXCoord(xc - width / 2.0, referenceConverter);
        int ymax = this.convYCoord(yc + heigth / 2.0, referenceConverter);
        graphics2D.drawArc(xmax, ymax, (int)width, (int)heigth, startAngle, endAngle);
    }

    protected void drawPolygonLine(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgLwPolyline dwgLwPolyline) {
        Point2D[] vertices = dwgLwPolyline.getVertices();
        if (vertices != null && vertices.length > 1) {
            for (int i = 0; i < vertices.length; ++i) {
                Point2D point2D = vertices[i];
                if (i >= vertices.length - 1) continue;
                Point2D nextPoint2D = vertices[i + 1];
                this.drawLine(referenceConverter, graphics2D, point2D, nextPoint2D);
            }
        }
    }

    protected void drawLine(ReferenceConverter referenceConverter, Graphics2D graphics2D, Point2D point2DToDraw, Point2D nextPoint2D) {
        this.graphics2DDrawLine(referenceConverter, graphics2D, point2DToDraw.getX(), point2DToDraw.getY(), nextPoint2D.getX(), nextPoint2D.getY());
    }

    protected void drawLine(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgLine dwgLine) {
        this.graphics2DDrawLine(referenceConverter, graphics2D, dwgLine.getP1()[0], dwgLine.getP1()[1], dwgLine.getP2()[0], dwgLine.getP2()[1]);
    }

    protected void drawArc(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgArc dwgArc) {
        int endAngle;
        int startAngle;
        double radius = dwgArc.getRadius();
        double xc = dwgArc.getCenter()[0];
        double yc = dwgArc.getCenter()[1];
        double ti = dwgArc.getInitAngle();
        double tf = dwgArc.getEndAngle();
        if (tf > ti) {
            startAngle = this.calcDegreeAngle(ti);
            endAngle = this.calcDegreeAngle(Math.abs(Math.abs(tf) - Math.abs(ti)));
        } else {
            startAngle = this.calcDegreeAngle(tf);
            endAngle = -1 * this.calcDegreeAngle(Math.abs(Math.abs(ti) - Math.abs(tf + Math.PI * 2)));
        }
        this.graphics2DDrawArc(referenceConverter, graphics2D, radius, xc, yc, startAngle, endAngle);
    }

    protected void drawText(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgText dwgText) {
        Point2D point2D = dwgText.getInsertionPoint();
        graphics2D.drawString(dwgText.getText(), this.convXCoord(point2D.getX(), referenceConverter), this.convYCoord(point2D.getY(), referenceConverter));
    }

    protected void drawText(ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgMText dwgMText) {
        graphics2D.drawString(DWGProcessor.getText(dwgMText), this.convXCoord(dwgMText.getInsertionPoint()[0], referenceConverter), this.convYCoord(dwgMText.getInsertionPoint()[1], referenceConverter));
    }

    protected static String getText(DwgMText dwgText) {
        String text = dwgText.getText();
        String[] strings = text.split(";");
        if (strings.length > 1) {
            strings = strings[strings.length - 1].split("}");
            text = strings[0];
        }
        return text;
    }

    private void graphics2DDrawArc(ReferenceConverter referenceConverter, Graphics2D graphics2D, double radius, double xc, double yc, int startAngle, int endAngle) {
        int xmax = this.convXCoord(xc - radius, referenceConverter);
        int ymax = this.convYCoord(yc + radius, referenceConverter);
        int xmin = this.convXCoord(xc + radius, referenceConverter);
        int ymin = this.convYCoord(yc - radius, referenceConverter);
        graphics2D.drawArc(xmax, ymax, Math.abs(xmax - xmin), Math.abs(ymax - ymin), startAngle, endAngle);
    }

    private void graphics2DDrawLine(ReferenceConverter referenceConverter, Graphics2D graphics2D, double x1, double y1, double x2, double y2) {
        int x1_ = this.convXCoord(x1, referenceConverter);
        int y1_ = this.convYCoord(y1, referenceConverter);
        int x2_ = this.convXCoord(x2, referenceConverter);
        int y2_ = this.convYCoord(y2, referenceConverter);
        graphics2D.drawLine(x1_, y1_, x2_, y2_);
    }

    protected DwgFile readDwgFile(String filename) throws IOException {
        DwgFile dwgFile = new DwgFile(filename);
        dwgFile.read();
        this.initializeDwgFile(dwgFile);
        return dwgFile;
    }

    private void initializeDwgFile(DwgFile dwgFile) {
        dwgFile.initializeLayerTable();
        dwgFile.applyExtrusions();
        dwgFile.blockManagement();
        dwgFile.calculateCadModelDwgPolylines();
        dwgFile.calculateGisModelDwgPolylines();
    }

    protected int calcDegreeAngle(double radians) {
        return (int)Math.round(radians * 180.0 / Math.PI);
    }

    protected int convXCoord(double coordinate, ReferenceConverter referenceConverter) {
        return (int)referenceConverter.convX(coordinate);
    }

    protected int convYCoord(double coordinate, ReferenceConverter referenceConverter) {
        return (int)referenceConverter.convY(coordinate);
    }

    public static class ReferenceConverter {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        int scaleRatio = 0;

        public ReferenceConverter(Vector<DwgObject> dwgObjects, int scaleRatio) {
            for (DwgObject dwgObject : dwgObjects) {
                double tf;
                if (dwgObject instanceof DwgText) {
                    DwgText dwgText = (DwgText)dwgObject;
                    this.minX = Math.min(this.minX, dwgText.getInsertionPoint().getX());
                    this.minY = Math.min(this.minY, dwgText.getInsertionPoint().getY());
                    this.maxX = Math.max(this.maxX, dwgText.getInsertionPoint().getX());
                    this.maxY = Math.max(this.maxY, dwgText.getInsertionPoint().getY());
                    continue;
                }
                if (dwgObject instanceof DwgArc) {
                    DwgArc dwgArc = (DwgArc)dwgObject;
                    double ti = dwgArc.getInitAngle();
                    if (ti == (tf = dwgArc.getEndAngle())) continue;
                    double r = dwgArc.getRadius();
                    double xc = dwgArc.getCenter()[0];
                    double yc = dwgArc.getCenter()[1];
                    double xi = r * Math.cos(ti) + xc;
                    double yi = r * Math.sin(ti) + yc;
                    double xf = r * Math.cos(tf) + xc;
                    double yf = r * Math.sin(tf) + yc;
                    this.minX = Math.min(this.minX, xi);
                    this.minX = Math.min(this.minX, xf);
                    this.minY = Math.min(this.minY, yi);
                    this.minY = Math.min(this.minY, yf);
                    this.maxX = Math.max(this.maxX, xi);
                    this.maxX = Math.max(this.maxX, xf);
                    this.maxY = Math.max(this.maxY, yi);
                    this.maxY = Math.max(this.maxY, yf);
                    continue;
                }
                if (dwgObject instanceof DwgLine) {
                    DwgLine dwgLine = (DwgLine)dwgObject;
                    this.minX = Math.min(this.minX, dwgLine.getP1()[0]);
                    this.minY = Math.min(this.minY, dwgLine.getP1()[1]);
                    this.maxX = Math.max(this.maxX, dwgLine.getP1()[0]);
                    this.maxY = Math.max(this.maxY, dwgLine.getP1()[1]);
                    this.minX = Math.min(this.minX, dwgLine.getP2()[0]);
                    this.minY = Math.min(this.minY, dwgLine.getP2()[1]);
                    this.maxX = Math.max(this.maxX, dwgLine.getP2()[0]);
                    this.maxY = Math.max(this.maxY, dwgLine.getP2()[1]);
                    continue;
                }
                if (dwgObject instanceof DwgLwPolyline) {
                    DwgLwPolyline dwgLwPolyline = (DwgLwPolyline)dwgObject;
                    Point2D[] vertices = dwgLwPolyline.getVertices();
                    if (vertices == null) continue;
                    for (Point2D point2D : vertices) {
                        this.minX = Math.min(this.minX, point2D.getX());
                        this.minY = Math.min(this.minY, point2D.getY());
                        this.maxX = Math.max(this.maxX, point2D.getX());
                        this.maxY = Math.max(this.maxY, point2D.getY());
                    }
                    continue;
                }
                if (dwgObject instanceof DwgEllipse) {
                    DwgEllipse dwgEllipse = (DwgEllipse)dwgObject;
                    double ti = dwgEllipse.getInitAngle();
                    if (ti == (tf = dwgEllipse.getEndAngle())) continue;
                    double width = ReferenceConverter.getEllipseWidth(dwgEllipse);
                    double heigth = ReferenceConverter.getEllipseHeigth(dwgEllipse);
                    double xc = dwgEllipse.getCenter()[0];
                    double yc = dwgEllipse.getCenter()[1];
                    double xi = width / 2.0 * Math.cos(ti) + xc;
                    double yi = heigth / 2.0 * Math.sin(ti) + yc;
                    double xf = width / 2.0 * Math.cos(tf) + xc;
                    double yf = heigth / 2.0 * Math.sin(tf) + yc;
                    this.minX = Math.min(this.minX, xi);
                    this.minX = Math.min(this.minX, xf);
                    this.minY = Math.min(this.minY, yi);
                    this.minY = Math.min(this.minY, yf);
                    this.maxX = Math.max(this.maxX, xi);
                    this.maxX = Math.max(this.maxX, xf);
                    this.maxY = Math.max(this.maxY, yi);
                    this.maxY = Math.max(this.maxY, yf);
                    continue;
                }
                if (dwgObject instanceof DwgCircle) {
                    DwgCircle dwgCircle = (DwgCircle)dwgObject;
                    boolean ti = false;
                    int tf2 = 360;
                    double r = dwgCircle.getRadius();
                    double xc = dwgCircle.getCenter()[0];
                    double yc = dwgCircle.getCenter()[1];
                    double xi = r * Math.cos(0.0) + xc;
                    double yi = r * Math.sin(0.0) + yc;
                    double xf = r * Math.cos(360.0) + xc;
                    double yf = r * Math.sin(360.0) + yc;
                    this.minX = Math.min(this.minX, xi);
                    this.minX = Math.min(this.minX, xf);
                    this.minY = Math.min(this.minY, yi);
                    this.minY = Math.min(this.minY, yf);
                    this.maxX = Math.max(this.maxX, xi);
                    this.maxX = Math.max(this.maxX, xf);
                    this.maxY = Math.max(this.maxY, yi);
                    this.maxY = Math.max(this.maxY, yf);
                    continue;
                }
                if (dwgObject instanceof DwgMText) {
                    DwgMText dwgMText = (DwgMText)dwgObject;
                    this.minX = Math.min(this.minX, dwgMText.getInsertionPoint()[0]);
                    this.minY = Math.min(this.minY, dwgMText.getInsertionPoint()[1]);
                    this.maxX = Math.max(this.maxX, dwgMText.getInsertionPoint()[0]);
                    this.maxY = Math.max(this.maxY, dwgMText.getInsertionPoint()[1]);
                    continue;
                }
                if (!(dwgObject instanceof DwgPoint) && !(dwgObject instanceof DwgBlockHeader) && !(dwgObject instanceof DwgLayer) && !(dwgObject instanceof DwgSolid) && !(dwgObject instanceof DwgBlock) && !(dwgObject instanceof DwgEndblk) && !(dwgObject instanceof DwgInsert) && !(dwgObject instanceof DwgAttdef) && !(dwgObject instanceof DwgAttrib) && !(dwgObject instanceof DwgSeqend) && !(dwgObject instanceof DwgPolyline2D) && !(dwgObject instanceof DwgVertex2D)) continue;
            }
            this.scaleRatio = (int)Math.round((double)scaleRatio / (1.0 - this.minX / this.maxX));
        }

        private double maxAbsValue(double maxX, double minX, double maxY, double minY) {
            return Math.max(Math.max(Math.abs(maxX), Math.abs(minX)), Math.max(Math.abs(maxY), Math.abs(minY)));
        }

        public static double getEllipseWidth(DwgEllipse dwgEllipse) {
            double[] vector = dwgEllipse.getMajorAxisVector();
            return vector[0] == 0.0 ? vector[1] * 2.0 * dwgEllipse.getAxisRatio() : vector[0] * 2.0;
        }

        public static double getEllipseHeigth(DwgEllipse dwgEllipse) {
            double[] vector = dwgEllipse.getMajorAxisVector();
            return vector[1] == 0.0 ? vector[0] * 2.0 * dwgEllipse.getAxisRatio() : vector[1] * 2.0;
        }

        public double convX(double x) {
            return (x - this.minX) * (double)this.scaleRatio / this.maxX;
        }

        public double convY(double y) {
            return (this.maxY - y) * (double)this.scaleRatio / this.maxX;
        }
    }
}

