/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.tasks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.spaces.domain.MetadataSpec;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.ui.InformationBean;

public class InitializeRoomClassficationTask
extends CustomTask {
    final Locale LocalePT = Locale.forLanguageTag("pt-PT");
    final Locale LocaleEN = Locale.forLanguageTag("en-GB");
    Multimap<String, MetadataSpec> codeToMetadataSpecMap;
    private static final String IMPORT_URL = "/home/sfbs/Documents/fenix-spaces/import";

    private void initMetadataSpecMap() {
        this.codeToMetadataSpecMap = HashMultimap.create();
        this.codeToMetadataSpecMap.put((Object)"Room", (Object)new MetadataSpec("ageQualitity", new LocalizedString.Builder().with(this.LocalePT, "Qualidade em idade").with(this.LocaleEN, "Age Quality").build(), Boolean.class, true, "false"));
        this.codeToMetadataSpecMap.put((Object)"Room", (Object)new MetadataSpec("distanceFromSanitaryInstalationsQuality", new LocalizedString.Builder().with(this.LocalePT, "Qualidade na dist\u00e2ncia \u00e0s instala\u00e7\u00f5es sanit\u00e1rias").with(this.LocaleEN, "Distance From Sanitary Instalations Quality").build(), Boolean.class, true, "false"));
        this.codeToMetadataSpecMap.put((Object)"Room", (Object)new MetadataSpec("heightQuality", new LocalizedString.Builder().with(this.LocalePT, "Qualidade em altura").with(this.LocaleEN, "Height Quality").build(), Boolean.class, true, "false"));
        this.codeToMetadataSpecMap.put((Object)"11", (Object)new MetadataSpec("illuminationQuality", new LocalizedString.Builder().with(this.LocalePT, "Qualidade em ilumina\u00e7\u00e3o").with(this.LocaleEN, "Illumination Quality").build(), Boolean.class, true, "false"));
        this.codeToMetadataSpecMap.put((Object)"Room", (Object)new MetadataSpec("securityQuality", new LocalizedString.Builder().with(this.LocalePT, "Qualidade em seguran\u00e7a").with(this.LocaleEN, "Security Quality").build(), Boolean.class, true, "false"));
        this.codeToMetadataSpecMap.put((Object)"Room", (Object)new MetadataSpec("doorNumber", new LocalizedString.Builder().with(this.LocalePT, "N\u00famero Porta").with(this.LocaleEN, "Door Number").build(), Integer.class, false, "0"));
        this.codeToMetadataSpecMap.put((Object)"Floor", (Object)new MetadataSpec("level", new LocalizedString.Builder().with(this.LocalePT, "Piso").with(this.LocaleEN, "Level").build(), Integer.class, true, "0"));
    }

    public InitializeRoomClassficationTask() {
        this.initMetadataSpecMap();
    }

    private void importClassificationsTask(Gson gson) {
        try {
            File file = new File("/home/sfbs/Documents/fenix-spaces/import/occupations_recent.json");
            List classificationJson = (List)gson.fromJson(new JsonReader((Reader)new FileReader(file)), new TypeToken<List<ClassificationBean>>(){}.getType());
            if (classificationJson != null) {
                for (ClassificationBean bean2 : classificationJson) {
                    this.create(null, bean2);
                }
            }
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void create(SpaceClassification parent, ClassificationBean bean2) {
        LocalizedString name = new LocalizedString.Builder().with(this.LocalePT, bean2.name).build();
        String code = bean2.code.toString();
        SpaceClassification spaceClassification = new SpaceClassification(code, name, parent);
        for (ClassificationBean child : bean2.childs) {
            this.create(spaceClassification, child);
        }
    }

    public void runTask() throws Exception {
        for (Space s : Bennu.getInstance().getSpaceSet()) {
            if (!s.getBlueprintFile().isPresent() || s.getBlueprintFile().get().getSize() != 0L) continue;
            InformationBean b = s.bean();
            b.setBlueprint(null);
            s.bean(b);
        }
        Gson gson = new Gson();
        this.importClassificationsTask(gson);
        this.initSpaceTypes();
    }

    public void initSpaceTypes() {
        String[] en = new String[]{"Campus", "Room Subdivision", "Building", "Floor"};
        String[] pt = new String[]{"Campus", "Subdivis\u00e3o de Sala", "Edif\u00edcio", "Piso"};
        String[] codes = new String[]{"3", "4", "5", "6"};
        SpaceClassification otherSpaces = SpaceClassification.get("11");
        for (int i = 0; i < codes.length; ++i) {
            String name_EN = en[i];
            String name_PT = pt[i];
            String code = codes[i];
            this.changeOrCreate(otherSpaces, name_EN, name_PT, code);
        }
    }

    public void changeOrCreate(SpaceClassification parent, String name_EN, String name_PT, String code) {
        LocalizedString name = new LocalizedString.Builder().with(this.LocalePT, name_PT).with(this.LocaleEN, name_EN).build();
        for (SpaceClassification classification : Bennu.getInstance().getRootClassificationSet()) {
            if (!classification.getCode().equals(code)) continue;
            classification.setName(name);
            String nameEn = classification.getName().getContent(this.LocaleEN);
            classification.setMetadataSpecs(this.getMetadataSpec(nameEn));
            return;
        }
        SpaceClassification spaceClassification = new SpaceClassification(code, name, parent, null);
        spaceClassification.setMetadataSpecs(this.getMetadataSpec(code));
    }

    private Collection<MetadataSpec> getMetadataSpec(String name) {
        return this.codeToMetadataSpecMap.get((Object)name);
    }

    private static class ClassificationBean {
        public String name;
        public Set<ClassificationBean> childs;
        public Integer code;

        public ClassificationBean(Integer code, String name, Set<ClassificationBean> childs) {
            this.code = code;
            this.name = name;
            this.childs = childs;
        }

        public ClassificationBean(Integer code, String name) {
            this(code, name, Sets.newHashSet());
        }
    }
}

