/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.config;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.spaces.domain.occupation.config.RepeatableConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class DailyConfig
extends RepeatableConfig {
    public DailyConfig(Interval interval, LocalTime startTime, LocalTime endTime, Integer repeatsEvery) {
        super(interval, startTime, endTime, repeatsEvery);
    }

    @Override
    public List<Interval> getIntervals() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        DateTime startDate = this.getInterval().getStart();
        DateTime endDate = this.getInterval().getEnd();
        DateTime start = startDate;
        while (start.isBefore((ReadableInstant)endDate) || start.isEqual((ReadableInstant)endDate)) {
            intervals.add(new Interval((ReadableInstant)start.withFields((ReadablePartial)this.getStartTime()), (ReadableInstant)start.withFields((ReadablePartial)this.getEndTime())));
            start = start.plusDays(this.getRepeatsEvery().intValue());
        }
        return intervals;
    }
}

