/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class SpaceOccupantsBean {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private String oldInterval;
    private String newInterval;
    private String action;
    private final JsonParser jsonParser = new JsonParser();
    private String warningMessage = "";
    private String user;

    private List<Interval> parseIntervals(String events) {
        JsonArray jsonEvents = this.jsonParser.parse(events).getAsJsonArray();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (JsonElement jsonEvent : jsonEvents) {
            JsonObject event = jsonEvent.getAsJsonObject();
            Long start = Long.parseLong(event.get("start").getAsString());
            Long end = Long.parseLong(event.get("end").getAsString());
            intervals.add(new Interval((ReadableInstant)new DateTime((Object)start), (ReadableInstant)new DateTime((Object)end)));
        }
        return intervals;
    }

    public User getUserObject() {
        return User.findByUsername((String)this.user);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public List<Interval> getOldIntervalList() {
        return this.parseIntervals(this.oldInterval);
    }

    public List<Interval> getNewIntervalList() {
        return this.parseIntervals(this.newInterval);
    }

    public String getOldInterval() {
        return this.oldInterval;
    }

    public void setOldInterval(String oldInterval) {
        this.oldInterval = oldInterval;
    }

    public String getNewInterval() {
        return this.newInterval;
    }

    public void setNewInterval(String newInterval) {
        this.newInterval = newInterval;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public boolean hasWarningMessage() {
        return !this.warningMessage.isEmpty();
    }

    public static boolean isAfter(DateTime d1, DateTime d2) {
        return d1.isAfter((ReadableInstant)d2);
    }
}

