/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.commons.i18n.LocalizedString;

public class MetadataSpec {
    private String name;
    private LocalizedString description;
    private Class<?> type;
    private boolean required;
    private String defaultValue;
    private boolean inactive;
    private boolean inherited;

    public MetadataSpec(String name, LocalizedString description, Class<?> type, boolean required, String defaultValue) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public MetadataSpec(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        this.setName(obj.get("name").getAsString());
        this.setDescription(LocalizedString.fromJson((JsonElement)obj.get("description")));
        try {
            this.setType(Class.forName(obj.get("type").getAsString()));
        }
        catch (ClassNotFoundException e) {
            this.setType(Object.class);
        }
        this.setRequired(obj.get("required").getAsBoolean());
        this.setDefaultValue(obj.get("defaultValue").getAsString());
        JsonElement inactiveJsonElement = obj.get("inactive");
        this.setInactive(inactiveJsonElement == null ? false : inactiveJsonElement.getAsBoolean());
        JsonElement inheritedJsonElement = obj.get("inherited");
        this.setInherited(inheritedJsonElement == null ? false : inheritedJsonElement.getAsBoolean());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedString description) {
        this.description = description;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.add("description", this.getDescription().json());
        json.addProperty("required", Boolean.valueOf(this.isRequired()));
        json.addProperty("defaultValue", this.getDefaultValue());
        json.addProperty("type", this.getType().getName());
        json.addProperty("inactive", Boolean.valueOf(this.isInactive()));
        json.addProperty("inherited", Boolean.valueOf(this.isInherited()));
        return json;
    }
}

