/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.requests;

import java.util.Comparator;
import java.util.Set;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.occupation.requests.OccupationComment_Base;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequest;
import org.fenixedu.spaces.domain.occupation.requests.OccupationRequestState;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class OccupationComment
extends OccupationComment_Base {
    public static final Comparator<OccupationComment> COMPARATOR_BY_INSTANT = new Comparator<OccupationComment>(){

        @Override
        public int compare(OccupationComment o1, OccupationComment o2) {
            int o = o1.getInstant().compareTo((ReadableInstant)o2.getInstant());
            return o != 0 ? o : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    public OccupationComment(OccupationRequest request, String subject, String description, User owner, DateTime instant) {
        this.checkIfCommentAlreadyExists(owner, subject, description);
        this.setRootDomainObject(Bennu.getInstance());
        this.setRequest(request);
        this.setOwner(owner);
        this.setSubject(subject);
        this.setDescription(description);
        this.setInstant(instant);
    }

    public void edit(String subject, String description) {
        if (!this.getRequest().getCurrentState().equals((Object)OccupationRequestState.NEW)) {
            throw new SpaceDomainException("error.OccupationRequest.impossible.edit", new String[0]);
        }
        this.setSubject(subject);
        this.setDescription(description);
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getInstant() != null && this.getSubject() != null && !this.getSubject().isEmpty() && this.getDescription() != null && !this.getDescription().isEmpty();
    }

    public String getPresentationInstant() {
        return this.getInstant().toString("dd/MM/yyyy HH:mm");
    }

    public OccupationRequestState getState() {
        return this.getRequest().getState(this.getInstant());
    }

    public void setInstant(DateTime instant) {
        if (instant == null) {
            throw new SpaceDomainException("error.OccupationComment.empty.instant", new String[0]);
        }
        super.setInstant(instant);
    }

    public void setDescription(String description) {
        if (description == null || description.isEmpty()) {
            throw new SpaceDomainException("error.OccupationComment.empty.description", new String[0]);
        }
        super.setDescription(description);
    }

    public void setSubject(String subject) {
        if (subject == null || subject.isEmpty()) {
            throw new SpaceDomainException("error.OccupationComment.empty.subject", new String[0]);
        }
        super.setSubject(subject);
    }

    public void setRequest(OccupationRequest request) {
        if (request == null) {
            throw new SpaceDomainException("error.OccupationComment.empty.request", new String[0]);
        }
        super.setRequest(request);
    }

    public void setOwner(User owner) {
        if (owner == null) {
            throw new SpaceDomainException("error.OccupationComment.empty.owner", new String[0]);
        }
        super.setOwner(owner);
    }

    private void checkIfCommentAlreadyExists(User owner, String subject, String description) {
        OccupationRequest request = this.getRequest();
        if (request != null) {
            Set comments = request.getCommentSet();
            for (OccupationComment comment : comments) {
                if (comment.getOwner() == null || !comment.getOwner().equals((Object)owner) || comment.getDescription().compareTo(description) != 0) continue;
                throw new SpaceDomainException("error.OccupationComment.comment.already.exists", new String[0]);
            }
        }
    }
}

