/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.BlueprintFile;
import org.fenixedu.spaces.domain.Information$Builder$callable$build;
import org.fenixedu.spaces.domain.Information_Base;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.domain.SpaceDomainException;
import org.fenixedu.spaces.domain.submission.SpacePhoto;
import org.fenixedu.spaces.ui.InformationBean;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Information
extends Information_Base {
    public static final Comparator<Information> CREATION_DATE_COMPARATOR = new Comparator<Information>(){

        @Override
        public int compare(Information o1, Information o2) {
            return o1.getCreated().compareTo((ReadableInstant)o2.getCreated());
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Information information) {
        return new Builder(information);
    }

    public static Builder builder(InformationBean bean2) {
        return new Builder(bean2);
    }

    protected Information() {
        this(null);
    }

    protected Information(Information previous) {
        this.setCreated(new DateTime());
        this.setPrevious(previous);
    }

    private Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, byte[] blueprint, BlueprintFile blueprintFile, byte[] spacePhoto, Set<SpacePhoto> spacePhotoSet, User user) {
        this.setValidFrom(validFrom);
        this.setValidUntil(validUntil);
        this.setAllocatableCapacity(allocatableCapacity);
        this.setBlueprintNumber(blueprintNumber);
        this.setArea(area);
        this.setName(name);
        this.setIdentification(identification);
        this.setClassification(classification);
        this.setMetadata(metadata);
        if (blueprintFile != null) {
            this.setBlueprint(blueprintFile);
        }
        if (blueprint != null) {
            this.setBlueprint(new BlueprintFile(name, blueprint));
        }
        if (spacePhotoSet != null) {
            this.getSpacePhotoSet().addAll(spacePhotoSet);
        }
        this.setUser(user);
    }

    @Deprecated
    protected Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, byte[] blueprint, User user) {
        this(validFrom, validUntil, allocatableCapacity, blueprintNumber, area, name, identification, metadata, classification, blueprint, null, null, null, user);
    }

    @Deprecated
    protected Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, BlueprintFile blueprintFile, User user) {
        this(validFrom, validUntil, allocatableCapacity, blueprintNumber, area, name, identification, metadata, classification, null, blueprintFile, null, null, user);
    }

    protected Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, byte[] blueprint, byte[] spacePhoto, Set<SpacePhoto> spacePhotoSet, User user) {
        this(validFrom, validUntil, allocatableCapacity, blueprintNumber, area, name, identification, metadata, classification, blueprint, null, spacePhoto, spacePhotoSet, user);
    }

    protected Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, byte[] blueprint, Set<SpacePhoto> spacePhotoSet, User user) {
        this(validFrom, validUntil, allocatableCapacity, blueprintNumber, area, name, identification, metadata, classification, blueprint, null, null, spacePhotoSet, user);
    }

    protected Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, BlueprintFile blueprintFile, byte[] spacePhoto, Set<SpacePhoto> spacePhotoSet, User user) {
        this(validFrom, validUntil, allocatableCapacity, blueprintNumber, area, name, identification, metadata, classification, null, blueprintFile, spacePhoto, spacePhotoSet, user);
    }

    protected Information(DateTime validFrom, DateTime validUntil, Integer allocatableCapacity, String blueprintNumber, BigDecimal area, String name, String identification, JsonElement metadata, SpaceClassification classification, BlueprintFile blueprintFile, Set<SpacePhoto> spacePhotoSet, User user) {
        this(validFrom, validUntil, allocatableCapacity, blueprintNumber, area, name, identification, metadata, classification, null, blueprintFile, null, spacePhotoSet, user);
    }

    public <T> Optional<T> getMetadata(String field) {
        Optional<JsonElement> spec = this.getClassification().getMetadataSpecJson(field);
        if (spec.isPresent()) {
            JsonObject jsObj = spec.get().getAsJsonObject();
            String type = jsObj.get("type").getAsString();
            JsonObject metadata = this.getMetadata().getAsJsonObject();
            JsonElement fieldValue = metadata.get(field);
            if (fieldValue == null || fieldValue.isJsonNull()) {
                return Optional.empty();
            }
            if (Boolean.class.getName().equalsIgnoreCase(type)) {
                return Optional.of(new Boolean(fieldValue.getAsBoolean()));
            }
            if (Integer.class.getName().equalsIgnoreCase(type)) {
                return Optional.of(new Integer(fieldValue.getAsInt()));
            }
            if (BigDecimal.class.getName().equalsIgnoreCase(type)) {
                return Optional.of(fieldValue.getAsBigDecimal());
            }
            return Optional.of(new String(fieldValue.getAsString()));
        }
        return Optional.empty();
    }

    protected Information copy() {
        Information clone = new Information();
        clone.setAllocatableCapacity(this.getAllocatableCapacity());
        clone.setBlueprintNumber(this.getBlueprintNumber());
        clone.setArea(this.getArea());
        clone.setName(this.getName());
        clone.setIdentification(this.getIdentification());
        clone.setValidFrom(this.getValidFrom());
        clone.setValidUntil(this.getValidUntil());
        clone.setMetadata(this.getMetadata());
        clone.setClassification(this.getClassification());
        clone.setPrevious(null);
        clone.setBlueprint(this.getBlueprint());
        clone.getSpacePhotoSet().addAll(this.getSpacePhotoSet());
        return clone;
    }

    protected Information keepLeft(DateTime checkpoint) {
        Information copy = this.copy();
        copy.setValidUntil(checkpoint);
        return copy;
    }

    protected Information keepRight(DateTime checkpoint) {
        Information copy = this.copy();
        copy.setValidFrom(checkpoint);
        return copy;
    }

    protected List<Information> split(DateTime checkpoint) {
        return Lists.newArrayList((Object[])new Information[]{this.keepLeft(checkpoint), this.keepRight(checkpoint)});
    }

    protected boolean contains(DateTime checkpoint) {
        return this.getValidity().contains((ReadableInstant)checkpoint);
    }

    protected boolean contains(Interval checkpoint) {
        return this.getValidity().contains((ReadableInterval)checkpoint);
    }

    protected boolean isAfter(DateTime checkpoint) {
        if (checkpoint == null) {
            return true;
        }
        return checkpoint.isEqual((ReadableInstant)this.getValidUntil()) || checkpoint.isAfter((ReadableInstant)this.getValidUntil());
    }

    protected Interval getValidity() {
        return new Interval((ReadableInstant)this.getValidFrom(), (ReadableInstant)(this.getValidUntil() == null ? new DateTime(Long.MAX_VALUE) : this.getValidUntil()));
    }

    public void setPrevious(Information previous) {
        if (previous == this) {
            throw new UnsupportedOperationException();
        }
        super.setPrevious(previous);
    }

    public static class Builder {
        private Integer allocatableCapacity;
        private String blueprintNumber;
        private BigDecimal area;
        private String name;
        private String identification;
        private JsonElement metadata;
        private DateTime validFrom;
        private DateTime validUntil;
        private SpaceClassification classification;
        private String externalId;
        private BlueprintFile blueprint;
        private byte[] blueprintContent;
        private Set<SpacePhoto> spacePhotoSet;
        private byte[] spacePhotoContent;
        private User user;
        public static final Advice advice$build = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

        public Builder(InformationBean informationBean) {
            this.allocatableCapacity = informationBean.getAllocatableCapacity();
            this.blueprintNumber = informationBean.getBlueprintNumber();
            this.area = informationBean.getArea();
            this.name = informationBean.getName();
            this.identification = informationBean.getIdentification();
            this.metadata = informationBean.getRawMetadata();
            this.validFrom = informationBean.getValidFrom();
            this.validUntil = informationBean.getValidUntil();
            this.classification = informationBean.getClassification();
            this.blueprintContent = informationBean.getBlueprintContent();
            this.blueprint = informationBean.getBlueprint();
            this.spacePhotoSet = informationBean.getSpacePhotoSet();
            this.spacePhotoContent = informationBean.getSpacePhotoContent();
            this.user = informationBean.getUser();
        }

        Builder(Information information) {
            this.allocatableCapacity = information.getAllocatableCapacity();
            this.blueprintNumber = information.getBlueprintNumber();
            this.area = information.getArea();
            this.name = information.getName();
            this.identification = information.getIdentification();
            this.metadata = information.getMetadata();
            this.validFrom = information.getValidFrom();
            this.validUntil = information.getValidUntil();
            this.classification = information.getClassification();
            this.externalId = information.getExternalId();
            this.blueprint = information.getBlueprint();
            this.spacePhotoSet = information.getSpacePhotoSet();
            this.user = information.getUser();
        }

        public Builder() {
        }

        public Builder allocatableCapacity(Integer allocatableCapacity) {
            this.allocatableCapacity = allocatableCapacity;
            return this;
        }

        public Builder blueprintNumber(String blueprintNumber) {
            this.blueprintNumber = blueprintNumber;
            return this;
        }

        public Builder area(BigDecimal area) {
            this.area = area;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder identification(String identification) {
            this.identification = identification;
            return this;
        }

        public Builder metadata(JsonElement metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder validFrom(DateTime validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public Builder validUntil(DateTime validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public Builder classification(SpaceClassification classification) {
            this.classification = classification;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Information build() {
            return (Information)((Object)advice$build.perform((Callable)new Information$Builder$callable$build(this)));
        }

        static /* synthetic */ Information advised$build(Builder this_) {
            Information info = null;
            if (this_.validUntil != null && this_.validFrom.isAfter((ReadableInstant)this_.validUntil)) {
                throw new SpaceDomainException("label.start.date.is.after.end.date", new String[0]);
            }
            info = this_.blueprintContent == null && this_.spacePhotoContent == null ? new Information(this_.validFrom, this_.validUntil, this_.allocatableCapacity, this_.blueprintNumber, this_.area, this_.name, this_.identification, this_.metadata, this_.classification, this_.blueprint, this_.spacePhotoSet, this_.user) : (this_.blueprintContent == null && this_.spacePhotoContent != null ? new Information(this_.validFrom, this_.validUntil, this_.allocatableCapacity, this_.blueprintNumber, this_.area, this_.name, this_.identification, this_.metadata, this_.classification, this_.blueprint, this_.spacePhotoContent, this_.spacePhotoSet, this_.user) : (this_.blueprintContent != null && this_.spacePhotoContent == null ? new Information(this_.validFrom, this_.validUntil, this_.allocatableCapacity, this_.blueprintNumber, this_.area, this_.name, this_.identification, this_.metadata, this_.classification, this_.blueprintContent, this_.spacePhotoSet, this_.user) : new Information(this_.validFrom, this_.validUntil, this_.allocatableCapacity, this_.blueprintNumber, this_.area, this_.name, this_.identification, this_.metadata, this_.classification, this_.blueprintContent, this_.spacePhotoContent, this_.spacePhotoSet, this_.user)));
            return info;
        }

        public InformationBean bean() {
            return new InformationBean(this.externalId, this.allocatableCapacity, this.blueprintNumber, this.area, this.name, this.identification, this.validFrom, this.validUntil, this.metadata, this.classification, this.blueprint, this.spacePhotoSet, this.user);
        }
    }
}

