/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.accessControl;

import java.util.stream.Stream;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.GroupStrategy;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

@GroupOperator(value="spaceManager")
public class SpaceManagersGroup
extends GroupStrategy {
    private static final long serialVersionUID = 1L;

    public Stream<User> getMembers() {
        return Space.getSpaces().filter(Space::isActive).map(s -> s.getManagementGroup()).filter(g -> g != null).flatMap(g -> g.getMembers());
    }

    public boolean isMember(User user) {
        return Space.getSpaces().filter(Space::isActive).anyMatch(space -> space.isSpaceManagementMember(user));
    }

    public Stream<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources/FenixEduSpacesResources", (String)("label.name." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[0]);
    }
}

