/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.domain.occupation.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.spaces.domain.occupation.config.RepeatableConfig;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class MonthlyConfig
extends RepeatableConfig {
    private final MonthlyType monthlyType;

    public MonthlyConfig(Interval interval, LocalTime startTime, LocalTime endTime, Integer repeatsEvery, MonthlyType monthlyType) {
        super(interval, startTime, endTime, repeatsEvery);
        this.monthlyType = monthlyType;
    }

    @Override
    public List<Interval> getIntervals() {
        switch (this.monthlyType) {
            case DAY_OF_MONTH: {
                return this.getDayOfMonthIntervals();
            }
            case DAY_OF_WEEK: {
                return this.getDayOfWeekIntervals();
            }
        }
        return Collections.emptyList();
    }

    private List<Interval> getDayOfWeekIntervals() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        DateTime startDate = this.getInterval().getStart();
        int nthDayOfWeek = this.getNthDayOfWeek(startDate);
        int dayOfWeek = startDate.getDayOfWeek();
        DateTime endDate = this.getInterval().getEnd();
        DateTime start = startDate;
        while (start.isBefore((ReadableInstant)endDate) || start.isEqual((ReadableInstant)endDate)) {
            intervals.add(new Interval((ReadableInstant)start.withFields((ReadablePartial)this.getStartTime()), (ReadableInstant)start.withFields((ReadablePartial)this.getEndTime())));
            start = start.plusMonths(this.getRepeatsEvery().intValue());
            start = this.getNextNthdayOfWeek(start, nthDayOfWeek, dayOfWeek);
        }
        return intervals;
    }

    private List<Interval> getDayOfMonthIntervals() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        DateTime startDate = this.getInterval().getStart();
        DateTime endDate = this.getInterval().getEnd();
        DateTime start = startDate;
        while (start.isBefore((ReadableInstant)endDate) || start.isEqual((ReadableInstant)endDate)) {
            intervals.add(new Interval((ReadableInstant)start.withFields((ReadablePartial)this.getStartTime()), (ReadableInstant)start.withFields((ReadablePartial)this.getEndTime())));
            start = start.plusMonths(this.getRepeatsEvery().intValue());
        }
        return intervals;
    }

    private int getNthDayOfWeek(DateTime when) {
        DateTime checkpoint = when;
        int whenDayOfWeek = checkpoint.getDayOfWeek();
        int month = checkpoint.getMonthOfYear();
        checkpoint = checkpoint.withDayOfMonth(1);
        checkpoint = checkpoint.withDayOfWeek(whenDayOfWeek);
        checkpoint = checkpoint.plusWeeks(month - checkpoint.getDayOfMonth());
        int i = 0;
        while (checkpoint.getMonthOfYear() == month && !checkpoint.isEqual((ReadableInstant)when)) {
            checkpoint = checkpoint.plusWeeks(1);
            ++i;
        }
        return i;
    }

    private DateTime getNextNthdayOfWeek(DateTime when, int nthdayOfTheWeek, int dayOfTheWeek) {
        DateTime checkpoint = when;
        int month = checkpoint.getMonthOfYear();
        checkpoint = checkpoint.withDayOfMonth(1);
        checkpoint = checkpoint.plusWeeks(month - checkpoint.getMonthOfYear());
        int i = nthdayOfTheWeek;
        if (i > 3) {
            DateTime lastDayOfMonth = checkpoint.dayOfMonth().withMaximumValue();
            lastDayOfMonth = lastDayOfMonth.withDayOfWeek(dayOfTheWeek);
            return lastDayOfMonth.plusWeeks(month - lastDayOfMonth.getMonthOfYear());
        }
        return checkpoint.plusWeeks(nthdayOfTheWeek);
    }

    static enum MonthlyType {
        DAY_OF_MONTH,
        DAY_OF_WEEK;

    }
}

