/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.spaces.services;

import com.google.common.io.ByteStreams;
import com.iver.cit.jdwglib.dwg.DwgFile;
import com.iver.cit.jdwglib.dwg.DwgObject;
import com.iver.cit.jdwglib.dwg.objects.DwgMText;
import com.iver.cit.jdwglib.dwg.objects.DwgText;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Vector;
import javax.servlet.UnavailableException;
import org.fenixedu.spaces.domain.BlueprintFile;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.services.DWGProcessor;
import org.joda.time.DateTime;

public class SpaceBlueprintsDWGProcessor
extends DWGProcessor {
    private Space parentSpace;
    private Boolean viewSpaceIdentifications;
    private Boolean viewBlueprintNumbers;
    private Boolean viewDoorNumbers;
    private Boolean suroundingSpaceBlueprint;
    private final Boolean viewOriginalSpaceBlueprint;
    private Space thisSpace;
    private DateTime when;

    public SpaceBlueprintsDWGProcessor(Space space, DateTime when, Boolean viewBlueprintNumbers_, Boolean viewSpaceIdentifications_, Boolean viewDoorNumbers_, BigDecimal scalePercentage) throws IOException {
        super(scalePercentage);
        this.thisSpace = space;
        this.parentSpace = SpaceBlueprintsDWGProcessor.getSuroundingSpaceMostRecentBlueprint(space);
        this.suroundingSpaceBlueprint = this.parentSpace != null;
        this.viewOriginalSpaceBlueprint = false;
        this.viewDoorNumbers = viewDoorNumbers_;
        this.viewSpaceIdentifications = viewSpaceIdentifications_;
        this.viewBlueprintNumbers = viewBlueprintNumbers_;
        this.when = when;
    }

    public SpaceBlueprintsDWGProcessor(BigDecimal scalePercentage) throws IOException {
        super(scalePercentage);
        this.viewOriginalSpaceBlueprint = true;
    }

    @Override
    protected void drawText(DWGProcessor.ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgMText dwgMText) {
        String text = SpaceBlueprintsDWGProcessor.getText(dwgMText);
        if (this.isToViewOriginalSpaceBlueprint() != null && this.isToViewOriginalSpaceBlueprint().booleanValue()) {
            super.drawText(referenceConverter, graphics2D, dwgMText);
        } else {
            int x = this.convXCoord(dwgMText.getInsertionPoint()[0], referenceConverter);
            int y = this.convYCoord(dwgMText.getInsertionPoint()[1], referenceConverter);
            Optional<Space> discoveredSpace = this.getParentSpace().readChildByBlueprintNumber(text.trim(), this.when);
            if (discoveredSpace.isPresent()) {
                String textToInsert = SpaceBlueprintsDWGProcessor.getTextToInsert(text, discoveredSpace.get(), this.isToViewBlueprintNumbers(), this.isToViewSpaceIdentifications(), this.isToViewDoorNumbers());
                this.drawTextAndArc(graphics2D, x, y, discoveredSpace.get(), textToInsert);
            }
        }
    }

    @Override
    protected void drawText(DWGProcessor.ReferenceConverter referenceConverter, Graphics2D graphics2D, DwgText dwgText) {
        if (this.isToViewOriginalSpaceBlueprint() != null && this.isToViewOriginalSpaceBlueprint().booleanValue()) {
            super.drawText(referenceConverter, graphics2D, dwgText);
        } else {
            Point2D point2D = dwgText.getInsertionPoint();
            int x = this.convXCoord(point2D.getX(), referenceConverter);
            int y = this.convYCoord(point2D.getY(), referenceConverter);
            Optional<Space> discoveredSpace = this.getParentSpace().readChildByBlueprintNumber(dwgText.getText().trim(), this.when);
            if (discoveredSpace.isPresent()) {
                String textToInsert = SpaceBlueprintsDWGProcessor.getTextToInsert(dwgText.getText(), discoveredSpace.get(), this.isToViewBlueprintNumbers(), this.isToViewSpaceIdentifications(), this.isToViewDoorNumbers());
                this.drawTextAndArc(graphics2D, x, y, discoveredSpace.get(), textToInsert);
            }
        }
    }

    public static BlueprintFile.BlueprintTextRectangles getBlueprintTextRectangles(InputStream inputStream, Space parentSpace, DateTime when, Boolean viewBlueprintNumbers, Boolean viewOriginalSpaceBlueprint, Boolean viewSpaceIdentifications, Boolean viewDoorNumbers, BigDecimal scalePercentage) throws IOException {
        BlueprintFile.BlueprintTextRectangles map = new BlueprintFile.BlueprintTextRectangles();
        if (viewOriginalSpaceBlueprint != null && viewOriginalSpaceBlueprint.booleanValue()) {
            return map;
        }
        File file = File.createTempFile("blueprint", "dwg");
        try (FileOutputStream fos = new FileOutputStream(file);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)fos);
        }
        SpaceBlueprintsDWGProcessor processor = new SpaceBlueprintsDWGProcessor(scalePercentage);
        DwgFile dwgFile = processor.readDwgFile(file.getAbsolutePath());
        Vector dwgObjects = dwgFile.getDwgObjects();
        DWGProcessor.ReferenceConverter referenceConverter = new DWGProcessor.ReferenceConverter(dwgObjects, processor.scaleRatio);
        for (DwgObject dwgObject : dwgObjects) {
            DwgMText dwgMText;
            String text;
            String textToInsert;
            Optional<Space> discoveredSpace;
            if (dwgObject instanceof DwgText) {
                DwgText dwgText = (DwgText)dwgObject;
                Point2D point2D = dwgText.getInsertionPoint();
                discoveredSpace = parentSpace.readChildByBlueprintNumber(dwgText.getText().trim(), when);
                if (!discoveredSpace.isPresent()) continue;
                textToInsert = SpaceBlueprintsDWGProcessor.getTextToInsert(dwgText.getText(), discoveredSpace.get(), viewBlueprintNumbers, viewSpaceIdentifications, viewDoorNumbers);
                SpaceBlueprintsDWGProcessor.putLinksCoordinatesToMap(map, processor, referenceConverter, point2D.getX(), point2D.getY(), textToInsert, discoveredSpace.get());
                continue;
            }
            if (!(dwgObject instanceof DwgMText) || !(discoveredSpace = parentSpace.readChildByBlueprintNumber((text = SpaceBlueprintsDWGProcessor.getText(dwgMText = (DwgMText)dwgObject)).trim(), when)).isPresent()) continue;
            textToInsert = SpaceBlueprintsDWGProcessor.getTextToInsert(text, discoveredSpace.get(), viewBlueprintNumbers, viewSpaceIdentifications, viewDoorNumbers);
            SpaceBlueprintsDWGProcessor.putLinksCoordinatesToMap(map, processor, referenceConverter, dwgMText.getInsertionPoint()[0], dwgMText.getInsertionPoint()[1], textToInsert, discoveredSpace.get());
        }
        return map;
    }

    private static void putLinksCoordinatesToMap(BlueprintFile.BlueprintTextRectangles map, SpaceBlueprintsDWGProcessor processor, DWGProcessor.ReferenceConverter referenceConverter, double x, double y, String textToInsert, Space space) {
        if (textToInsert != null) {
            ArrayList<BlueprintFile.BlueprintTextRectangle> blueprintTextRectangules = (ArrayList<BlueprintFile.BlueprintTextRectangle>)map.get(space);
            if (blueprintTextRectangules == null) {
                blueprintTextRectangules = new ArrayList<BlueprintFile.BlueprintTextRectangle>();
            }
            blueprintTextRectangules.add(new BlueprintFile.BlueprintTextRectangle(textToInsert, processor.convXCoord(x, referenceConverter), processor.convYCoord(y, referenceConverter), processor.fontSize));
            map.put(space, blueprintTextRectangules);
        }
    }

    private void drawArcAroundText(Graphics2D graphics2D, int x, int y, String textToInsert) {
        double numberOfCharacters = textToInsert.length();
        double characterWidth = (double)this.fontSize / 1.6;
        double textSize = numberOfCharacters * characterWidth;
        int x1 = (int)((double)x - characterWidth);
        int y1 = y - 2 * this.fontSize;
        int width = (int)((double)Math.round(textSize) + 2.0 * characterWidth);
        int height = 4 * this.fontSize;
        int startAngle = 0;
        int arcAngle = 360;
        graphics2D.setColor(Color.YELLOW);
        graphics2D.fillArc(x1, y1, width, height, startAngle, arcAngle);
        graphics2D.setColor(Color.BLACK);
    }

    private void drawTextAndArc(Graphics2D graphics2D, int x, int y, Space discoveredSpace, String textToInsert) {
        if (textToInsert != null) {
            if (this.isSuroundingSpaceBlueprint() != null && this.isSuroundingSpaceBlueprint().booleanValue() && this.getThisSpace() != null && discoveredSpace.equals(this.getThisSpace())) {
                this.drawArcAroundText(graphics2D, x, y, textToInsert);
                graphics2D.drawString(textToInsert, x, y);
            } else {
                graphics2D.drawString(textToInsert, x, y);
            }
        }
    }

    private static String getTextToInsert(String textToInsert, Space space, Boolean isToViewBlueprintNumbers, Boolean isToViewSpaceIdentifications, Boolean isToViewDoorNumbers) {
        if (space != null) {
            if (isToViewSpaceIdentifications != null && isToViewSpaceIdentifications.booleanValue()) {
                return space.getName().trim();
            }
            if (isToViewDoorNumbers != null && isToViewDoorNumbers.booleanValue()) {
                String name = space.getMetadata("doorNumber").orElse("-");
                return name.trim();
            }
            if (isToViewBlueprintNumbers != null && isToViewBlueprintNumbers.booleanValue()) {
                return textToInsert.trim();
            }
        }
        return null;
    }

    public Space getParentSpace() {
        return this.parentSpace;
    }

    public Boolean isToViewBlueprintNumbers() {
        return this.viewBlueprintNumbers;
    }

    public Boolean isToViewSpaceIdentifications() {
        return this.viewSpaceIdentifications;
    }

    public Boolean isToViewDoorNumbers() {
        return this.viewDoorNumbers;
    }

    public Boolean isSuroundingSpaceBlueprint() {
        return this.suroundingSpaceBlueprint;
    }

    public Boolean getViewBlueprintNumbers() {
        return this.viewBlueprintNumbers;
    }

    public Space getThisSpace() {
        return this.thisSpace;
    }

    public Boolean isToViewOriginalSpaceBlueprint() {
        return this.viewOriginalSpaceBlueprint;
    }

    public static Space getSuroundingSpaceMostRecentBlueprint(Space space) {
        Optional<BlueprintFile> blueprintFile = space.getBlueprintFile();
        if (blueprintFile.isPresent()) {
            return space;
        }
        if (space.getParent() != null) {
            return SpaceBlueprintsDWGProcessor.getSuroundingSpaceMostRecentBlueprint(space.getParent());
        }
        return null;
    }

    public static void writeBlueprint(Space space, DateTime when, Boolean isToViewOriginalSpaceBlueprint, Boolean viewBlueprintNumbers, Boolean isToViewIdentifications, Boolean isToViewDoorNumbers, BigDecimal scalePercentage, OutputStream writer) throws IOException, UnavailableException {
        Optional<BlueprintFile> blueprintFile;
        Space suroundingSpaceMostRecentBlueprint = SpaceBlueprintsDWGProcessor.getSuroundingSpaceMostRecentBlueprint(space);
        if (suroundingSpaceMostRecentBlueprint != null && (blueprintFile = suroundingSpaceMostRecentBlueprint.getBlueprintFile()).isPresent()) {
            byte[] blueprintBytes = blueprintFile.get().getContent();
            SpaceBlueprintsDWGProcessor processor = null;
            processor = isToViewOriginalSpaceBlueprint != null && isToViewOriginalSpaceBlueprint != false ? new SpaceBlueprintsDWGProcessor(scalePercentage) : new SpaceBlueprintsDWGProcessor(space, when, viewBlueprintNumbers, isToViewIdentifications, isToViewDoorNumbers, scalePercentage);
            if (processor != null) {
                processor.generateJPEGImage(blueprintBytes, writer);
            }
        }
    }
}

