/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.domain.serviceRequests;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.domain.serviceRequests.AcademicServiceRequestTemplate$callable$create;
import org.fenixedu.qubdocs.domain.serviceRequests.AcademicServiceRequestTemplate$callable$create$1;
import org.fenixedu.qubdocs.domain.serviceRequests.AcademicServiceRequestTemplate$callable$createCustom;
import org.fenixedu.qubdocs.domain.serviceRequests.AcademicServiceRequestTemplate_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicServiceRequestTemplate
extends AcademicServiceRequestTemplate_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createCustom = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AcademicServiceRequestTemplate(LocalizedString name, LocalizedString description, User creator) {
        this.setCreator(creator);
        this.setUpdater(creator);
        this.init(name, description);
    }

    protected AcademicServiceRequestTemplate(LocalizedString name, LocalizedString description, Locale language, boolean custom, User creator) {
        this(name, description, creator);
        this.setLanguage(language);
        this.setCustom(custom);
    }

    public void delete() {
        this.getDocumentTemplateFile().delete();
        this.setDegree(null);
        this.setProgramConclusion(null);
        this.setDegreeType(null);
        this.setServiceRequestType(null);
        this.setUpdater(null);
        this.setCreator(null);
        this.setBennu(null);
        this.deleteDomainObject();
    }

    public static Stream<AcademicServiceRequestTemplate> findAll() {
        return Bennu.getInstance().getDocumentTemplatesSet().stream().filter(dt -> dt instanceof AcademicServiceRequestTemplate).map(AcademicServiceRequestTemplate.class::cast);
    }

    public static AcademicServiceRequestTemplate matchTemplateFor(Locale language, ServiceRequestType serviceRequestType, DegreeType degreeType, ProgramConclusion programConclusion, Degree degree) {
        if (serviceRequestType != null) {
            for (AcademicServiceRequestTemplate template : serviceRequestType.getAcademicServiceRequestTemplatesSet()) {
                if (!template.getActive().booleanValue() || template.getCustom().booleanValue() || !template.getLanguage().equals(language) || template.getDegreeType() != degreeType || template.getDegree() != degree || template.getProgramConclusion() != programConclusion) continue;
                return template;
            }
        }
        return null;
    }

    public static AcademicServiceRequestTemplate findTemplateFor(Locale language, ServiceRequestType serviceRequestType, DegreeType degreeType, ProgramConclusion programConclusion, Degree degree) {
        AcademicServiceRequestTemplate matchedTemplate = AcademicServiceRequestTemplate.matchTemplateFor(language, serviceRequestType, degreeType, programConclusion, degree);
        if (matchedTemplate != null) {
            return matchedTemplate;
        }
        matchedTemplate = AcademicServiceRequestTemplate.matchTemplateFor(language, serviceRequestType, degreeType, null, degree);
        if (matchedTemplate != null) {
            return matchedTemplate;
        }
        matchedTemplate = AcademicServiceRequestTemplate.matchTemplateFor(language, serviceRequestType, degreeType, programConclusion, null);
        if (matchedTemplate != null) {
            return matchedTemplate;
        }
        matchedTemplate = AcademicServiceRequestTemplate.matchTemplateFor(language, serviceRequestType, degreeType, null, null);
        if (matchedTemplate != null) {
            return matchedTemplate;
        }
        matchedTemplate = AcademicServiceRequestTemplate.matchTemplateFor(language, serviceRequestType, null, null, null);
        return matchedTemplate;
    }

    public static Set<AcademicServiceRequestTemplate> readCustomTemplatesFor(Locale language, ServiceRequestType serviceRequestType) {
        HashSet<AcademicServiceRequestTemplate> customTemplates = new HashSet<AcademicServiceRequestTemplate>();
        for (AcademicServiceRequestTemplate template : serviceRequestType.getAcademicServiceRequestTemplatesSet()) {
            if (!template.getCustom().booleanValue() || !template.getActive().booleanValue() || !template.getLanguage().equals(language)) continue;
            customTemplates.add(template);
        }
        return customTemplates;
    }

    public static AcademicServiceRequestTemplate create(LocalizedString localizedString, LocalizedString localizedString2, Locale locale, ServiceRequestType serviceRequestType, DegreeType degreeType, ProgramConclusion programConclusion, Degree degree, User user) {
        return (AcademicServiceRequestTemplate)((Object)advice$create.perform((Callable)new AcademicServiceRequestTemplate$callable$create(localizedString, localizedString2, locale, serviceRequestType, degreeType, programConclusion, degree, user)));
    }

    static /* synthetic */ AcademicServiceRequestTemplate advised$create(LocalizedString name, LocalizedString description, Locale language, ServiceRequestType serviceRequestType, DegreeType degreeType, ProgramConclusion programConclusion, Degree degree, User creator) {
        AcademicServiceRequestTemplate oldTemplate = AcademicServiceRequestTemplate.matchTemplateFor(language, serviceRequestType, degreeType, programConclusion, degree);
        if (oldTemplate != null) {
            oldTemplate.setActive(false);
        }
        AcademicServiceRequestTemplate template = new AcademicServiceRequestTemplate(name == null || name.isEmpty() ? serviceRequestType.getName() : name, description == null || description.isEmpty() ? AcademicServiceRequestTemplate.buildTemplateDescription(degreeType, programConclusion, degree) : description, language, false, creator);
        template.setServiceRequestType(serviceRequestType);
        template.setDegreeType(degreeType);
        template.setProgramConclusion(programConclusion);
        template.setDegree(degree);
        return template;
    }

    public static AcademicServiceRequestTemplate create(LocalizedString localizedString, LocalizedString localizedString2, Locale locale, ServiceRequestType serviceRequestType, DegreeType degreeType, ProgramConclusion programConclusion, Degree degree) {
        return (AcademicServiceRequestTemplate)((Object)advice$create$1.perform((Callable)new AcademicServiceRequestTemplate$callable$create$1(localizedString, localizedString2, locale, serviceRequestType, degreeType, programConclusion, degree)));
    }

    static /* synthetic */ AcademicServiceRequestTemplate advised$create(LocalizedString name, LocalizedString description, Locale language, ServiceRequestType serviceRequestType, DegreeType degreeType, ProgramConclusion programConclusion, Degree degree) {
        return AcademicServiceRequestTemplate.create(name, description, language, serviceRequestType, degreeType, programConclusion, degree, Authenticate.getUser());
    }

    public static AcademicServiceRequestTemplate createCustom(LocalizedString localizedString, LocalizedString localizedString2, Locale locale, ServiceRequestType serviceRequestType) {
        return (AcademicServiceRequestTemplate)((Object)advice$createCustom.perform((Callable)new AcademicServiceRequestTemplate$callable$createCustom(localizedString, localizedString2, locale, serviceRequestType)));
    }

    static /* synthetic */ AcademicServiceRequestTemplate advised$createCustom(LocalizedString name, LocalizedString description, Locale language, ServiceRequestType serviceRequestType) {
        AcademicServiceRequestTemplate template = new AcademicServiceRequestTemplate(name == null || name.isEmpty() ? serviceRequestType.getName() : name, description == null || description.isEmpty() ? new LocalizedString() : description, language, true, Authenticate.getUser());
        template.setServiceRequestType(serviceRequestType);
        return template;
    }

    private static LocalizedString buildTemplateDescription(DegreeType degreeType, ProgramConclusion programConclusion, Degree degree) {
        LocalizedString description = new LocalizedString();
        if (programConclusion != null) {
            description.append(programConclusion.getName());
            description.append(" - ");
        }
        if (degreeType != null) {
            description.append(degreeType.getName());
            description.append(" ");
        }
        if (degree != null) {
            description.append(degree.getPresentationNameI18N());
        }
        return description;
    }
}

