/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.domain;

import com.google.common.base.Predicate;
import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.core.IDocumentTemplate;
import com.qubit.terra.docs.core.IDocumentTemplateVersion;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.io.domain.FileStorageConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.FenixEduDocumentGenerator;
import org.fenixedu.qubdocs.domain.DocumentTemplate$callable$activateDocument;
import org.fenixedu.qubdocs.domain.DocumentTemplate$callable$deactivateDocument;
import org.fenixedu.qubdocs.domain.DocumentTemplate$callable$edit;
import org.fenixedu.qubdocs.domain.DocumentTemplateFile;
import org.fenixedu.qubdocs.domain.DocumentTemplate_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DocumentTemplate
extends DocumentTemplate_Base
implements IDocumentTemplate {
    public static Filters filters;
    public static final Advice advice$edit;
    public static final Advice advice$deactivateDocument;
    public static final Advice advice$activateDocument;

    protected DocumentTemplate() {
        this.setBennu(Bennu.getInstance());
        this.setCreationDate(new DateTime());
        this.setUpdateDate(new DateTime());
        this.setCreator(Authenticate.getUser());
        this.setUpdater(Authenticate.getUser());
        this.setActive(true);
    }

    protected DocumentTemplate(LocalizedString name, LocalizedString description) {
        this();
        this.init(name, description);
    }

    protected void init(LocalizedString name, LocalizedString description) {
        this.setName(name);
        this.setDescription(description);
        this.checkRules();
    }

    protected void checkRules() {
        DocumentTemplate.check(this.getName(), "error.DocumentTemplate.name.required");
        DocumentTemplate.check(this.getDescription(), "error.DocumentTemplate.remarks.required");
        DocumentTemplate.check(this.getCreationDate(), "error.DocumentTemplate.creationDate.required");
        DocumentTemplate.check(this.getUpdateDate(), "error.DocumentTemplate.updateDate.required");
        DocumentTemplate.check(this.getCreator(), "error.DocumentTemplate.creationResponsible.required");
        DocumentTemplate.check(this.getUpdater(), "error.DocumentTemplate.updateResponsible.required");
    }

    private static <T> void check(T subject, String exceptionCause) {
        if (subject == null) {
            throw new DomainException(exceptionCause, new String[0]);
        }
    }

    public IDocumentTemplateVersion getCurrentVersion() {
        return this.getDocumentTemplateFile();
    }

    public boolean isActive() {
        return this.getActive() != null && this.getActive() != false;
    }

    public void edit(LocalizedString localizedString, LocalizedString localizedString2) {
        Object object = advice$edit.perform((Callable)new DocumentTemplate$callable$edit(this, localizedString, localizedString2));
    }

    static /* synthetic */ void advised$edit(DocumentTemplate this_, LocalizedString name, LocalizedString description) {
        this_.setName(name);
        this_.setDescription(description);
        this_.setUpdateDate(new DateTime());
        this_.setUpdater(Authenticate.getUser());
        this_.checkRules();
    }

    public void deactivateDocument() {
        Object object = advice$deactivateDocument.perform((Callable)new DocumentTemplate$callable$deactivateDocument(this));
    }

    static /* synthetic */ void advised$deactivateDocument(DocumentTemplate this_) {
        this_.setActive(false);
        this_.checkRules();
    }

    public void activateDocument() {
        Object object = advice$activateDocument.perform((Callable)new DocumentTemplate$callable$activateDocument(this));
    }

    static /* synthetic */ void advised$activateDocument(DocumentTemplate this_) {
        this_.setActive(true);
    }

    public Set<? extends DocumentTemplate> readAllDocuments() {
        return DocumentTemplateEngine.getServiceImplementation().readAllDocuments();
    }

    public Set<? extends DocumentTemplate> readActiveDocuments() {
        return DocumentTemplateEngine.getServiceImplementation().readActiveDocuments();
    }

    public DocumentTemplateFile createFile(String filename, byte[] content) {
        return DocumentTemplateFile.create(this, filename, content);
    }

    public FenixEduDocumentGenerator createGeneratorForDocx(Collection<? extends IReportDataProvider> dataProviders) {
        return this.createGenerator(dataProviders, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    public FenixEduDocumentGenerator createGeneratorForPdf(Collection<? extends IReportDataProvider> dataProviders) {
        return this.createGenerator(dataProviders, "application/pdf");
    }

    public FenixEduDocumentGenerator createGenerator(Collection<? extends IReportDataProvider> dataProviders, String mimeTypeFormat) {
        FenixEduDocumentGenerator reportGenerator = FenixEduDocumentGenerator.create(this, mimeTypeFormat);
        reportGenerator.registerDataProviders(dataProviders);
        return reportGenerator;
    }

    public static final boolean isStorageDefined() {
        return FileStorageConfiguration.readFileStorageByFileType((String)DocumentTemplate.class.getName()) != null;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deactivateDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$activateDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        filters = new Filters();
    }

    public static class Filters {
        public Predicate<DocumentTemplate> active(final Boolean value) {
            return new Predicate<DocumentTemplate>(){

                public boolean apply(DocumentTemplate template) {
                    return template.getActive().equals(value);
                }
            };
        }
    }
}

