/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.util.reports.helpers;

import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.YearMonthDay;

public class DateHelper
implements IDocumentHelper {
    private Locale locale;

    public DateHelper() {
    }

    public DateHelper(Locale locale) {
        this.locale = locale;
    }

    public String numericDate(LocalDate localDate) {
        return localDate.toString("dd/MM/yyyy");
    }

    public String numericDate(YearMonthDay yearMonthDay) {
        return this.numericDate(yearMonthDay.toLocalDate());
    }

    public String numericDateTime(DateTime dateTime) {
        return dateTime.toString("dd/MM/yyyy HH:mm");
    }

    public LocalizedString extendedDate(LocalDate localDate) {
        LocalizedString i18NString = new LocalizedString();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            String month = localDate.toString("MMMM", locale);
            if (locale.getLanguage().equals("pt")) {
                month = month.toLowerCase();
            }
            Object day = String.valueOf(localDate.getDayOfMonth());
            if (locale.getLanguage().equals("en")) {
                day = (String)day + this.getDayOfMonthOrdinalInEn(localDate.getDayOfMonth());
            }
            String message = BundleUtil.getString((String)"resources.FenixeduQubdocsReportsResources", (Locale)locale, (String)"message.DateHelper.extendedDate", (String[])new String[]{day, month, localDate.toString("yyyy", locale)});
            i18NString = i18NString.with(locale, message);
        }
        return i18NString;
    }

    public LocalizedString extendedDate(YearMonthDay yearMonthDay) {
        return this.extendedDate(yearMonthDay.toLocalDate());
    }

    public String monthYear(Partial partial) {
        return partial.toString("MM/yyyy");
    }

    public String monthYear(LocalDate localDate) {
        return localDate.toString("MM/yyyy");
    }

    public String date(DateTime dateTime) {
        return dateTime.toString("dd/MM/yyyy");
    }

    public String date(LocalDate localDate) {
        return localDate.toString("dd/MM/yyyy");
    }

    public String date(YearMonthDay yearMonthDay) {
        return yearMonthDay.toString("dd/MM/yyyy");
    }

    public String freeMarkerDate(LocalDate localDate) {
        return localDate.toString("MM/dd/yyyy");
    }

    public String freeMarkerDate(YearMonthDay yearMonthDay) {
        return yearMonthDay.toString("MM/dd/yyyy");
    }

    public String now() {
        return this.numericDateTime(new DateTime());
    }

    public String today() {
        return this.date(new DateTime());
    }

    public LocalizedString extendedToday() {
        return this.extendedDate(new LocalDate());
    }

    public String getDayOfMonthOrdinal(int day, boolean isMale, boolean isPlural) {
        if (this.locale == null || this.locale.getLanguage().equals("pt")) {
            return this.getDayOfMonthOrdinalInPt(day, isMale, isPlural);
        }
        if (this.locale.getLanguage().equals("en")) {
            return this.getDayOfMonthOrdinalInEn(day);
        }
        return "Unknown Language";
    }

    private String getDayOfMonthOrdinalInPt(int day, boolean isMale, boolean isPlural) {
        if (isMale) {
            if (isPlural) {
                return "\u1d52\u02e2";
            }
            return "\u00ba";
        }
        if (isPlural) {
            return "\u1d43\u02e2";
        }
        return "\u00aa";
    }

    private String getDayOfMonthOrdinalInEn(int day) {
        if (day >= 11 && day <= 13) {
            return "\u1d57\u02b0";
        }
        switch (day % 10) {
            case 1: {
                return "\u02e2\u1d57";
            }
            case 2: {
                return "\u207f\u1d48";
            }
            case 3: {
                return "\u02b3\u1d48";
            }
        }
        return "\u1d57\u02b0";
    }
}

