/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.preprocessors;

import com.qubit.terra.docs.util.processors.pre.ReportGeneratorPreProcessor;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class QubListPreProcessor
extends ReportGeneratorPreProcessor {
    public static final String FUNCTION_NAME = "qubList";
    public static final Pattern PATTERN = Pattern.compile("\\s*qubList\\s*\\(\\s*\"(.+)\"\\s*\\)");
    public static final List<String> METADATA_NODE_NAMES = Arrays.asList("office:document-content", "office:body", "office:text");
    public static final List<String> TABLE_NODE_NAMES = Arrays.asList("table:table", "table:table-column", "table:table-row", "table:table-cell");
    public static final String SECTION_NODE_NAME = "text:section";
    public static final String COLUMN_NODE_REPEATED_ATT = "table:number-columns-repeated";

    public String getEntryName() {
        return "content.xml";
    }

    protected void visit(Document document, String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) throws XDocReportException {
        Node textNode = document;
        for (String nodeName : METADATA_NODE_NAMES) {
            textNode = this.getNodeByName(textNode.getChildNodes(), nodeName);
        }
        ArrayList<Node> tableList = new ArrayList<Node>();
        ArrayList<Node> sectionList = new ArrayList<Node>();
        this.findTableNodes(tableList, sectionList, textNode);
        List<Node> cellNodes = this.getCellNodes(tableList);
        this.processCellNodes(cellNodes, fieldsMetadata);
        this.processCellNodes(sectionList, fieldsMetadata);
    }

    protected void findTableNodes(List<Node> tableList, List<Node> sectionList, Node node) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child.getNodeName().equals(TABLE_NODE_NAMES.get(0))) {
                tableList.add(child);
            }
            if (!child.getNodeName().equals(SECTION_NODE_NAME)) continue;
            sectionList.add(child);
            this.findTableNodes(tableList, sectionList, child);
        }
    }

    protected Node getNodeByName(NodeList childrenList, String nodeName) {
        for (int i = 0; i < childrenList.getLength(); ++i) {
            Node node = childrenList.item(i);
            if (!node.getNodeName().equals(nodeName)) continue;
            return node;
        }
        throw new RuntimeException(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"error.unexpected.document.format", (String[])new String[0]));
    }

    protected List<Node> getCellNodes(List<Node> tableList) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node tableNode : tableList) {
            Node cellNode;
            Node rowNode;
            Node columnNode;
            if (tableNode.getChildNodes().getLength() != 2 || !(columnNode = tableNode.getChildNodes().item(0)).getNodeName().equals(TABLE_NODE_NAMES.get(1)) || this.hasAttribute(columnNode, COLUMN_NODE_REPEATED_ATT) || !(rowNode = tableNode.getChildNodes().item(1)).getNodeName().equals(TABLE_NODE_NAMES.get(2)) || rowNode.getChildNodes().getLength() != 1 || !(cellNode = rowNode.getChildNodes().item(0)).getNodeName().equals(TABLE_NODE_NAMES.get(3))) continue;
            result.add(cellNode);
        }
        return result;
    }

    protected boolean hasAttribute(Node node, String attribute) {
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attributeNode = node.getAttributes().item(i);
            if (!attributeNode.getNodeName().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    protected void processCellNodes(List<Node> cellNodes, FieldsMetadata fieldsMetadata) {
        for (Node cellNode : cellNodes) {
            if (cellNode instanceof Text) {
                this.processCellText((Text)cellNode, fieldsMetadata);
                continue;
            }
            this.processCellNodes(cellNode.getChildNodes(), fieldsMetadata);
        }
    }

    protected void processCellNodes(NodeList childNodes, FieldsMetadata fieldsMetadata) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child instanceof Text) {
                this.processCellText((Text)child, fieldsMetadata);
                continue;
            }
            this.processCellNodes(child.getChildNodes(), fieldsMetadata);
        }
    }

    protected void processCellText(Text node, FieldsMetadata fieldsMetadata) {
        Matcher matcher = PATTERN.matcher(node.getData());
        while (matcher.find()) {
            String[] includes;
            for (String include : includes = matcher.group(1).split(" ")) {
                fieldsMetadata.addFieldAsList(include);
            }
        }
        node.setData(matcher.replaceAll(""));
    }
}

