/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.task;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeTypeInstance;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.fenixedu.commons.i18n.LocalizedString;

public class FMDConfigurationScript
extends CustomTask {
    private static final Locale pt = new Locale("pt", "PT");
    private static final Locale en = new Locale("en", "GB");

    public void runTask() throws Exception {
        HashMap<String, LocalizedString> documentPurposeTypes = new HashMap<String, LocalizedString>();
        documentPurposeTypes.put("FAMILY_ALLOWANCE", new LocalizedString(pt, "Abono de Fam\u00edlia").with(en, "Family Allowance"));
        documentPurposeTypes.put("MILITARY", new LocalizedString(pt, "Fins Militares").with(en, "Military Purposes"));
        documentPurposeTypes.put("PUBLIC_TRANSPORTS", new LocalizedString(pt, "Transportes P\u00fablicos").with(en, "Public Transports"));
        documentPurposeTypes.put("STUDY_SCHOLARSHIP", new LocalizedString(pt, "Bolsa de Estudo").with(en, "Scholarship"));
        documentPurposeTypes.put("PROFESSIONAL", new LocalizedString(pt, "Fins Profissionais").with(en, "Professional purposes"));
        documentPurposeTypes.put("PPRE", new LocalizedString(pt, "PPRE").with(en, "PPRE"));
        documentPurposeTypes.put("IMMIGRATION", new LocalizedString(pt, "SEF").with(en, "Immigration"));
        documentPurposeTypes.put("OTHER", new LocalizedString(pt, "Outra").with(en, "Other"));
        for (Map.Entry entry : documentPurposeTypes.entrySet()) {
            DocumentPurposeTypeInstance dpti2;
            if (DocumentPurposeTypeInstance.findUnique((String)((String)entry.getKey())) == null) {
                try {
                    DocumentPurposeType documentPurposeType = DocumentPurposeType.valueOf((String)((String)entry.getKey()));
                    dpti2 = DocumentPurposeTypeInstance.create((String)((String)entry.getKey()), (LocalizedString)((LocalizedString)entry.getValue()), (DocumentPurposeType)documentPurposeType);
                }
                catch (IllegalArgumentException iae) {
                    dpti2 = DocumentPurposeTypeInstance.create((String)((String)entry.getKey()), (LocalizedString)((LocalizedString)entry.getValue()));
                }
            } else {
                dpti2 = DocumentPurposeTypeInstance.findUnique((String)((String)entry.getKey()));
                dpti2.setName((LocalizedString)entry.getValue());
            }
            dpti2.setActive(Boolean.valueOf(true));
            for (ServiceRequestType srt : dpti2.getServiceRequestTypesSet()) {
                dpti2.removeServiceRequestTypes(srt);
            }
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"SCHOOL_REGISTRATION_CERTIFICATE").get());
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"SCHOOL_REGISTRATION_DECLARATION").get());
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"ENROLMENT_CERTIFICATE").get());
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"ENROLMENT_DECLARATION").get());
        }
        DocumentPurposeTypeInstance.findActives().filter(dpti -> !documentPurposeTypes.containsKey(dpti.getCode())).forEach(dpti -> dpti.setActive(Boolean.valueOf(false)));
        DocumentSigner.create(AdministrativeOffice.readDegreeAdministrativeOffice(), "Concei\u00e7\u00e3o Manso", "Concei\u00e7\u00e3o Manso", new LocalizedString(pt, "Respons\u00e1vel dos Servi\u00e7os Acad\u00e9micos"), new LocalizedString(pt, "Faculdade de Medicina Dent\u00e1ria"), Gender.FEMALE);
        DocumentSigner.create(AdministrativeOffice.readDegreeAdministrativeOffice(), "Eduardo Brunheta", "Eduardo Brunheta", new LocalizedString(pt, "Assistente T\u00e9cnico"), new LocalizedString(pt, "Faculdade de Medicina Dent\u00e1ria"), Gender.MALE);
        DocumentSigner.create(AdministrativeOffice.readDegreeAdministrativeOffice(), "Cristina Fernandes", "Cristina Fernandes", new LocalizedString(pt, "Diretora Executiva"), new LocalizedString(pt, "Faculdade de Medicina Dent\u00e1ria"), Gender.FEMALE);
    }
}

