/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.Locale;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;

public class RegistrationDataProvider
implements IReportDataProvider {
    protected static final String KEY = "registration";
    protected static final String KEY_FOR_NUMBER_ENROLED_CURRICULAR_COURSES_IN_CURRENT_YEAR = "numberEnroledCurricularCoursesInCurrentYear";
    protected Registration registration;

    public RegistrationDataProvider(Registration registration, Locale locale) {
        this.registration = registration;
    }

    public boolean handleKey(String key) {
        return KEY.equals(key) || KEY_FOR_NUMBER_ENROLED_CURRICULAR_COURSES_IN_CURRENT_YEAR.equals(key);
    }

    public void registerFieldsAndImages(IDocumentFieldsData arg0) {
    }

    public Object valueForKey(String key) {
        if (KEY.equals(key)) {
            return this.registration;
        }
        if (KEY_FOR_NUMBER_ENROLED_CURRICULAR_COURSES_IN_CURRENT_YEAR.equals(key)) {
            return this.getNumberEnroledCurricularCoursesInCurrentYear(this.registration);
        }
        return null;
    }

    private int getNumberEnroledCurricularCoursesInCurrentYear(Registration registration) {
        StudentCurricularPlan lastStudentCurricularPlan = registration.getLastStudentCurricularPlan();
        if (lastStudentCurricularPlan == null) {
            return 0;
        }
        long result = lastStudentCurricularPlan.getEnrolmentsSet().stream().filter(e -> e.getExecutionInterval().getExecutionYear().isCurrent()).count();
        return Math.toIntExact(result);
    }
}

