/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class StandaloneCurriculumEntriesDataProvider
implements IReportDataProvider {
    protected static final String KEY = "standaloneCurriculumEntries";
    protected static final String KEY_FOR_REMARKS = "approvementStandaloneRemarks";
    protected static final String KEY_FOR_TOTAL_UNITS = "totalStandaloneApprovements";
    protected static final String KEY_FOR_TOTAL_ECTS = "totalStandaloneApprovedECTS";
    protected Registration registration;
    protected CurriculumEntryRemarksDataProvider remarksDataProvider;
    protected Locale locale;
    protected Collection<ICurriculumEntry> standaloneApprovements;
    protected Set<CurriculumEntry> curriculumEntries;
    protected CurriculumEntryServices service;

    public StandaloneCurriculumEntriesDataProvider(Registration registration, Collection<ICurriculumEntry> standaloneApprovements, Locale locale, CurriculumEntryServices service) {
        this.registration = registration;
        this.locale = locale;
        this.remarksDataProvider = new CurriculumEntryRemarksDataProvider(registration, standaloneApprovements, service);
        this.standaloneApprovements = standaloneApprovements;
        this.service = service;
        this.init();
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY);
        documentFieldsData.registerCollectionAsField(KEY_FOR_REMARKS);
    }

    public boolean handleKey(String key) {
        if (this.standaloneApprovements == null || this.standaloneApprovements.isEmpty()) {
            return false;
        }
        return KEY.equals(key) || KEY_FOR_REMARKS.equals(key) || KEY_FOR_TOTAL_UNITS.equals(key) || KEY_FOR_TOTAL_ECTS.equals(key);
    }

    public Object valueForKey(String key) {
        if (key.equals(KEY)) {
            return this.getCurriculumEntries();
        }
        if (key.equals(KEY_FOR_REMARKS)) {
            return this.getRemarks();
        }
        if (key.equals(KEY_FOR_TOTAL_UNITS)) {
            return this.getTotalApprovements();
        }
        if (key.equals(KEY_FOR_TOTAL_ECTS)) {
            return this.getApprovedEcts();
        }
        return null;
    }

    protected Set<CurriculumEntry> getCurriculumEntries() {
        return this.curriculumEntries;
    }

    private int getTotalApprovements() {
        if (this.curriculumEntries == null) {
            return 0;
        }
        return this.curriculumEntries.size();
    }

    private BigDecimal getApprovedEcts() {
        if (this.curriculumEntries == null) {
            return BigDecimal.ZERO;
        }
        return this.curriculumEntries.stream().map(CurriculumEntry::getEctsCredits).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Object getRemarks() {
        return this.remarksDataProvider.valueForKey("curriculumEntryRemarks");
    }

    protected void init() {
        if (this.standaloneApprovements != null) {
            HashSet entries = Sets.newHashSet(this.standaloneApprovements);
            this.curriculumEntries = Sets.newTreeSet((Comparator)new Comparator<CurriculumEntry>(){

                @Override
                public int compare(CurriculumEntry left, CurriculumEntry right) {
                    if (left.getExecutionYear() == right.getExecutionYear()) {
                        return this.compareByName(left, right);
                    }
                    return left.getExecutionYear().compareTo(right.getExecutionYear());
                }

                public int compareByName(CurriculumEntry left, CurriculumEntry right) {
                    String leftContent = left.getName().getContent(StandaloneCurriculumEntriesDataProvider.this.locale) != null ? left.getName().getContent(StandaloneCurriculumEntriesDataProvider.this.locale) : left.getName().getContent();
                    String rightContent = right.getName().getContent(StandaloneCurriculumEntriesDataProvider.this.locale) != null ? right.getName().getContent(StandaloneCurriculumEntriesDataProvider.this.locale) : right.getName().getContent();
                    leftContent = leftContent.toLowerCase();
                    rightContent = rightContent.toLowerCase();
                    return leftContent.compareTo(rightContent);
                }
            });
            this.curriculumEntries.addAll(CurriculumEntry.transform(this.registration, entries, this.remarksDataProvider, this.service));
        }
    }
}

