/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;
import org.fenixedu.qubdocs.util.DocsStringUtils;
import org.joda.time.LocalDate;

public class CurriculumEntry
implements Comparable<CurriculumEntry> {
    private final ICurriculumEntry iCurriculumEntry;
    private final CurriculumEntryRemarksDataProvider remarksDataProvider;
    private final Registration registration;
    private final CurriculumEntryServices service;
    private static Function<ICurriculumEntry, String> courseEctsGradeProvider = entry -> "";

    public CurriculumEntry(Registration registration, ICurriculumEntry entry, CurriculumEntryRemarksDataProvider remarksDataProvider, CurriculumEntryServices service) {
        this.registration = registration;
        this.iCurriculumEntry = entry;
        this.remarksDataProvider = remarksDataProvider;
        this.service = service;
    }

    public LocalizedString getName() {
        if (this.iCurriculumEntry instanceof IEnrolment && ((IEnrolment)this.iCurriculumEntry).isEnrolment()) {
            return ((Enrolment)this.iCurriculumEntry).getCurricularCourse().getNameI18N(this.iCurriculumEntry.getExecutionPeriod());
        }
        return this.iCurriculumEntry.getName();
    }

    public BigDecimal getEctsCredits() {
        return this.iCurriculumEntry.getEctsCreditsForCurriculum();
    }

    public BigDecimal getWeight() {
        return this.iCurriculumEntry.getWeigthForCurriculum();
    }

    public BigDecimal getTheoreticalHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getTheoreticalHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getProblemHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getProblemsHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getLaboratorialHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getLaboratorialHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getContactLoadHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getContactLoad(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getSeminaryHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getSeminaryHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getFieldWorkHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getFieldWorkHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getTrainingPeriodHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getTrainingPeriodHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getTutorialOrientationHours() {
        if (this.isCurriculumLine()) {
            return new BigDecimal(this.getCompetenceCourse().getTutorialOrientationHours(this.iCurriculumEntry.getExecutionPeriod()));
        }
        return null;
    }

    public BigDecimal getOtherHours() {
        if (this.isCurriculumLine()) {
            double autonomousWorkHours = this.getCompetenceCourse().getAutonomousWorkHours(this.iCurriculumEntry.getExecutionPeriod());
            double fieldWorkHours = this.getCompetenceCourse().getFieldWorkHours(this.iCurriculumEntry.getExecutionPeriod());
            double seminaryHours = this.getCompetenceCourse().getSeminaryHours(this.iCurriculumEntry.getExecutionPeriod());
            return new BigDecimal(autonomousWorkHours + fieldWorkHours + seminaryHours);
        }
        return null;
    }

    public BigDecimal getTotalHours() {
        if (this.isCurriculumLine()) {
            double autonomousWorkHours = this.getCompetenceCourse().getAutonomousWorkHours(this.iCurriculumEntry.getExecutionPeriod());
            double fieldWorkHours = this.getCompetenceCourse().getFieldWorkHours(this.iCurriculumEntry.getExecutionPeriod());
            double seminaryHours = this.getCompetenceCourse().getSeminaryHours(this.iCurriculumEntry.getExecutionPeriod());
            double theoreticalHours = this.getCompetenceCourse().getTheoreticalHours(this.iCurriculumEntry.getExecutionPeriod());
            double problemsHours = this.getCompetenceCourse().getProblemsHours(this.iCurriculumEntry.getExecutionPeriod());
            double laboratorialHours = this.getCompetenceCourse().getLaboratorialHours(this.iCurriculumEntry.getExecutionPeriod());
            double trainingPeriodHours = this.getCompetenceCourse().getTrainingPeriodHours(this.iCurriculumEntry.getExecutionPeriod());
            double tutorialOrientationHours = this.getCompetenceCourse().getTutorialOrientationHours(this.iCurriculumEntry.getExecutionPeriod());
            return new BigDecimal(autonomousWorkHours + fieldWorkHours + seminaryHours + theoreticalHours + problemsHours + laboratorialHours + trainingPeriodHours + tutorialOrientationHours);
        }
        return null;
    }

    public String getCode() {
        return this.getCompetenceCourse().getCode();
    }

    public ExecutionInterval getExecutionSemester() {
        return this.iCurriculumEntry.getExecutionInterval();
    }

    public String getCurricularYear() {
        if (this.isExternal()) {
            return "-";
        }
        CurriculumLine input = (CurriculumLine)this.iCurriculumEntry;
        if (input.getCurriculumGroup().getDegreeModule() == null) {
            return "-";
        }
        return "" + this.service.getCurricularYear(input);
    }

    public String getGrade() {
        return this.iCurriculumEntry.getGradeValue();
    }

    public LocalizedString getGradeDescription() {
        return DocsStringUtils.capitalize(BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)this.iCurriculumEntry.getGradeValue(), (String[])new String[0]));
    }

    public ExecutionYear getExecutionYear() {
        return this.iCurriculumEntry.getExecutionYear();
    }

    public String getExecutionYearName() {
        return this.getExecutionYear().getName();
    }

    public LocalDate getApprovementDate() {
        return this.getICurriculumEntry().getApprovementDate().toLocalDate();
    }

    protected boolean isCurriculumLine() {
        return this.iCurriculumEntry instanceof CurriculumLine;
    }

    protected CurriculumLine getCurriculumLine() {
        return (CurriculumLine)this.iCurriculumEntry;
    }

    protected Dismissal getDismissal() {
        return (Dismissal)this.iCurriculumEntry;
    }

    public IEnrolment getIEnrolment() {
        return (IEnrolment)this.iCurriculumEntry;
    }

    public ExternalEnrolment getExternalEnrolment() {
        return (ExternalEnrolment)this.iCurriculumEntry;
    }

    protected CompetenceCourse getCompetenceCourse() {
        return this.getCurriculumLine().getCurricularCourse().getCompetenceCourse();
    }

    public ICurriculumEntry getICurriculumEntry() {
        return this.iCurriculumEntry;
    }

    public boolean isExternal() {
        return this.iCurriculumEntry instanceof ExternalEnrolment;
    }

    public boolean isDismissal() {
        return this.iCurriculumEntry instanceof Dismissal;
    }

    public boolean isIEnrolment() {
        return this.iCurriculumEntry instanceof IEnrolment;
    }

    public boolean isExtraCurricular() {
        return this.iCurriculumEntry instanceof Enrolment && ((Enrolment)this.iCurriculumEntry).isExtraCurricular();
    }

    public boolean isPropedeutics() {
        return this.iCurriculumEntry instanceof Enrolment && ((Enrolment)this.iCurriculumEntry).isPropaedeutic();
    }

    public boolean isStandalone() {
        return this.iCurriculumEntry instanceof Enrolment && ((Enrolment)this.iCurriculumEntry).isStandalone();
    }

    public boolean isAnnual() {
        if (!(this.iCurriculumEntry instanceof CurriculumLine)) {
            return false;
        }
        CurriculumLine line = (CurriculumLine)this.iCurriculumEntry;
        return line.getDegreeModule() != null && line.getCurricularCourse().getCompetenceCourse() != null && line.getCurricularCourse().getCompetenceCourse().isAnual();
    }

    public String getRemarkNumbers() {
        return this.remarksDataProvider.getRemarkIdsFor(this);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CurriculumEntry && this.getICurriculumEntry() == ((CurriculumEntry)obj).getICurriculumEntry();
    }

    public LocalizedString getTypeOfCourse() {
        return null;
    }

    protected StudentCurricularPlan getStudentCurricularPlan() {
        return this.registration.getLastStudentCurricularPlan();
    }

    public static void setCourseEctsGradeProviderProvider(Function<ICurriculumEntry, String> courseEctsGradeProvider) {
        CurriculumEntry.courseEctsGradeProvider = courseEctsGradeProvider;
    }

    protected String getEctsGrade(ICurriculumEntry entry) {
        return (String)courseEctsGradeProvider.apply((Object)entry);
    }

    public String getEctsGrade() {
        return this.getEctsGrade(this.getICurriculumEntry());
    }

    public LocalizedString getDurationName() {
        if (this.isDismissal()) {
            return BundleUtil.getLocalizedString((String)"resources.AcademicAdminOffice", (String)(this.getDismissal().isAnual() ? "diploma.supplement.annual" : "diploma.supplement.semestral"), (String[])new String[0]);
        }
        return BundleUtil.getLocalizedString((String)"resources.AcademicAdminOffice", (String)(this.getIEnrolment().isAnual() ? "diploma.supplement.annual" : "diploma.supplement.semestral"), (String[])new String[0]);
    }

    public static Set<CurriculumEntry> transform(final Registration registration, Collection<? extends ICurriculumEntry> entries, final CurriculumEntryRemarksDataProvider remarksDataProvider, final CurriculumEntryServices service) {
        HashSet result = Sets.newHashSet();
        result.addAll(Collections2.transform(entries, (Function)new Function<ICurriculumEntry, CurriculumEntry>(){

            public CurriculumEntry apply(ICurriculumEntry entry) {
                return new CurriculumEntry(registration, entry, remarksDataProvider, service);
            }
        }));
        return result;
    }

    public static Comparator<CurriculumEntry> NAME_COMPARATOR(final Locale locale) {
        return new Comparator<CurriculumEntry>(){

            @Override
            public int compare(CurriculumEntry o1, CurriculumEntry o2) {
                String nameO2;
                String nameO1 = o1.getName().getContent(locale) != null ? o1.getName().getContent(locale) : o1.getName().getContent();
                int result = nameO1.compareTo(nameO2 = o2.getName().getContent(locale) != null ? o2.getName().getContent(locale) : o2.getName().getContent());
                if (result != 0) {
                    return result;
                }
                return o1.compareTo(o2);
            }
        };
    }

    public static Comparator<CurriculumEntry> EXECUTION_YEAR_NAME_COMPARATOR(Locale locale) {
        final Comparator<CurriculumEntry> name_comparator = CurriculumEntry.NAME_COMPARATOR(locale);
        return new Comparator<CurriculumEntry>(){

            @Override
            public int compare(CurriculumEntry o1, CurriculumEntry o2) {
                int result = o1.getExecutionYear().compareTo(o2.getExecutionYear());
                if (result != 0) {
                    return result;
                }
                return name_comparator.compare(o1, o2);
            }
        };
    }

    @Override
    public int compareTo(CurriculumEntry o) {
        return ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_ID.compare(this.getICurriculumEntry(), o.getICurriculumEntry());
    }
}

