/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class DegreeCurricularPlanInformationDataProvider
implements IReportDataProvider {
    protected static final String KEY = "curricularPlanInformation";
    protected Registration registration;
    protected CycleType cycleType;
    protected ExecutionYear executionYear;
    protected LocalDate conclusionDate;

    public DegreeCurricularPlanInformationDataProvider(Registration registration, CycleType cycleType, ExecutionYear executionYear) {
        this.registration = registration;
        this.cycleType = cycleType;
        this.executionYear = executionYear;
    }

    public DegreeCurricularPlanInformationDataProvider(Registration registration, ExecutionYear executionYear) {
        this(registration, null, executionYear);
    }

    public DegreeCurricularPlanInformationDataProvider(Registration registration, CycleType cycleType, ExecutionYear executionYear, LocalDate conclusionDate) {
        this(registration, cycleType, executionYear);
        this.conclusionDate = conclusionDate;
        this.checkData();
    }

    public DegreeCurricularPlanInformationDataProvider(Registration registration, ExecutionYear executionYear, LocalDate conclusionDate) {
        this(registration, null, executionYear, conclusionDate);
    }

    protected void checkData() {
        if (this.getDegreeOfficialPublication() == null) {
            throw new DomainException("error.DegreeCurricularPlanInformationDataProvider.degreeOfficialPublication.required", new String[0]);
        }
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
    }

    public boolean handleKey(String key) {
        return KEY.equals(key);
    }

    public Object valueForKey(String key) {
        return this.handleKey(key) ? this : null;
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return (DegreeCurricularPlan)this.getDegree().getDegreeCurricularPlansForYear(this.executionYear).iterator().next();
    }

    public LocalizedString getDegreeCertifiedName() {
        return null;
    }

    public LocalizedString getDegreeName() {
        return this.getDegree().getNameI18N();
    }

    public LocalizedString getDegreePresentationName() {
        return this.getDegree().getPresentationNameI18N(this.executionYear);
    }

    private Degree getDegree() {
        return this.registration.getDegree();
    }

    public LocalizedString getDegreeTypeFilteredName() {
        return this.registration.getDegreeType().getName();
    }

    public LocalizedString getBranchName() {
        return null;
    }

    public boolean isCurricularPlanWithBranch() {
        return false;
    }

    public LocalizedString getCycleTypeName() {
        if (this.cycleType != null) {
            return this.cycleType.getDescriptionI18N();
        }
        if (this.registration.getDegreeType().getCycleTypes().size() == 1) {
            return null;
        }
        throw new DomainException("error.DegreeCurricularPlanInformationProvider.more.than.one.cycle", new String[0]);
    }

    public CycleType getCycleType() {
        return this.cycleType;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public Integer getNumberOfYears() {
        return 0;
    }

    public Integer getNumberOfSemesters() {
        return 0;
    }

    public BigDecimal getEcts() {
        return new BigDecimal(this.registration.getLastStudentCurricularPlan().getDegreeCurricularPlan().getCycleCourseGroup(this.getCycleType()).getDefaultEcts(this.executionYear));
    }

    protected DegreeOfficialPublication getDegreeOfficialPublication() {
        return this.getDegree().getOfficialPublicationSet().stream().filter(op -> op.getPublication().toDateTimeAtStartOfDay().isBefore((ReadableInstant)this.conclusionDate.toDateTimeAtStartOfDay())).sorted((x, y) -> -x.getPublication().toDateTimeAtStartOfDay().compareTo((ReadableInstant)y.getPublication().toDateTimeAtStartOfDay())).findFirst().orElse(null);
    }

    public String getDegreeOfficialPublicationName() {
        if (this.getDegreeOfficialPublication() == null) {
            throw new DomainException("error.DegreeCurricularPlanInformationDataProvider.degreeOfficialPublication.empty", new String[0]);
        }
        return this.getDegreeOfficialPublication().getOfficialReference();
    }

    public LocalDate getDegreeOfficialPublicationDate() {
        if (this.getDegreeOfficialPublication() == null) {
            throw new DomainException("error.DegreeCurricularPlanInformationDataProvider.degreeOfficialPublication.empty", new String[0]);
        }
        return this.getDegreeOfficialPublication().getPublication();
    }

    public boolean isSecondCycle() {
        return this.cycleType == CycleType.SECOND_CYCLE || this.getDegree().isSecondCycle();
    }

    public boolean isFirstCycle() {
        return this.cycleType == CycleType.FIRST_CYCLE || this.getDegree().isFirstCycle();
    }

    public boolean isThirdCycle() {
        return this.getDegree().isThirdCycle();
    }
}

