/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.util.reports.helpers;

import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class CurricularHelper
implements IDocumentHelper {
    private static final List<CycleType> ACCEPTED_CYCLES = Arrays.asList(CycleType.FIRST_CYCLE, CycleType.SECOND_CYCLE, CycleType.THIRD_CYCLE);

    public CycleType getCourseHigherCycle(ICurriculumEntry curriculumEntry, boolean competenceScope) {
        if (!(curriculumEntry instanceof CurriculumLine)) {
            return null;
        }
        CurriculumLine curriculumLine = (CurriculumLine)curriculumEntry;
        if (!competenceScope) {
            CycleCurriculumGroup cycleCurriculumGroup = curriculumLine.getParentCycleCurriculumGroup();
            return cycleCurriculumGroup != null ? cycleCurriculumGroup.getCycleType() : null;
        }
        DegreeModule degreeModule = curriculumLine.getDegreeModule();
        if (!(degreeModule instanceof CurricularCourse)) {
            return null;
        }
        Collection contexts = ((CurricularCourse)degreeModule).getCompetenceCourse().getAssociatedCurricularCoursesSet().stream().flatMap(cc -> cc.getParentContextsByExecutionYear(curriculumEntry.getExecutionYear()).stream()).collect(Collectors.toSet());
        HashSet<CycleCourseGroup> result = new HashSet<CycleCourseGroup>();
        for (Context context : contexts) {
            if (context.getParentCourseGroup().isCycleCourseGroup()) {
                result.add((CycleCourseGroup)context.getParentCourseGroup());
            }
            result.addAll(context.getParentCourseGroup().getParentCycleCourseGroups());
        }
        return result.stream().map(ccg -> ccg.getCycleType()).filter(ct -> ACCEPTED_CYCLES.contains(ct)).sorted(CycleType.COMPARATOR_BY_GREATER_WEIGHT).findFirst().orElse(null);
    }

    public CycleType getCourseLowerCycle(ICurriculumEntry curriculumEntry, boolean competenceScope) {
        if (!(curriculumEntry instanceof CurriculumLine)) {
            return null;
        }
        CurriculumLine curriculumLine = (CurriculumLine)curriculumEntry;
        if (!competenceScope) {
            CycleCurriculumGroup cycleCurriculumGroup = curriculumLine.getParentCycleCurriculumGroup();
            return cycleCurriculumGroup != null ? cycleCurriculumGroup.getCycleType() : null;
        }
        DegreeModule degreeModule = curriculumLine.getDegreeModule();
        if (!(degreeModule instanceof CurricularCourse)) {
            return null;
        }
        Collection contexts = ((CurricularCourse)degreeModule).getCompetenceCourse().getAssociatedCurricularCoursesSet().stream().flatMap(cc -> cc.getParentContextsByExecutionYear(curriculumEntry.getExecutionYear()).stream()).collect(Collectors.toSet());
        HashSet<CycleCourseGroup> result = new HashSet<CycleCourseGroup>();
        for (Context context : contexts) {
            if (context.getParentCourseGroup().isCycleCourseGroup()) {
                result.add((CycleCourseGroup)context.getParentCourseGroup());
            }
            result.addAll(context.getParentCourseGroup().getParentCycleCourseGroups());
        }
        return result.stream().map(ccg -> ccg.getCycleType()).filter(ct -> ACCEPTED_CYCLES.contains(ct)).sorted(CycleType.COMPARATOR_BY_GREATER_WEIGHT.reversed()).findFirst().orElse(null);
    }
}

