/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.util.reports.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.util.Locale;
import org.fenixedu.commons.i18n.LocalizedString;

public class LanguageHelper
implements IDocumentHelper {
    private Locale locale;

    public LanguageHelper() {
    }

    public LanguageHelper(Locale locale) {
        this.locale = locale;
    }

    public String i18n(String localizedStringJson) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(localizedStringJson);
        LocalizedString i18nString = LocalizedString.fromJson((JsonElement)jsonElement);
        return this.i18n(i18nString);
    }

    public String i18n(LocalizedString i18nString) {
        if (i18nString == null || this.locale == null) {
            return "-";
        }
        String message = i18nString.getContent(this.locale);
        return message != null ? message : "";
    }

    public String pt(LocalizedString i18nString) {
        if (i18nString == null) {
            return "-";
        }
        String message = i18nString.getContent(new Locale("pt", "PT"));
        return message != null ? message : "";
    }

    public String en(LocalizedString i18nString) {
        if (i18nString == null) {
            return "-";
        }
        String message = i18nString.getContent(new Locale("en", "GB"));
        return message != null ? message : "";
    }
}

