/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.task;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeTypeInstance;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.fenixedu.commons.i18n.LocalizedString;

public class FFConfigurationScript
extends CustomTask {
    private static final Locale pt = new Locale("pt", "PT");
    private static final Locale en = new Locale("en", "GB");

    public void runTask() throws Exception {
        HashMap<String, LocalizedString> documentPurposeTypes = new HashMap<String, LocalizedString>();
        documentPurposeTypes.put("FAMILY_BENEFITS", new LocalizedString(pt, "Presta\u00e7\u00f5es Familiares").with(en, "Family Benefits"));
        documentPurposeTypes.put("IRS", new LocalizedString(pt, "IRS").with(en, "Taxes"));
        documentPurposeTypes.put("ADSE", new LocalizedString(pt, "ADSE").with(en, "ADSE"));
        documentPurposeTypes.put("SOCIAL_SECURITY", new LocalizedString(pt, "Seguran\u00e7a Social").with(en, "Social Security"));
        documentPurposeTypes.put("MILITARY", new LocalizedString(pt, "Fins Militares").with(en, "Military Purposes"));
        documentPurposeTypes.put("PUBLIC_TRANSPORTS", new LocalizedString(pt, "Transportes P\u00fablicos").with(en, "Public Transports"));
        documentPurposeTypes.put("STUDY_SCHOLARSHIP", new LocalizedString(pt, "Bolsa de Estudo").with(en, "Scholarship"));
        documentPurposeTypes.put("PROFESSIONAL", new LocalizedString(pt, "Fins Profissionais").with(en, "Professional purposes"));
        documentPurposeTypes.put("PPRE", new LocalizedString(pt, "PPRE").with(en, "PPRE"));
        documentPurposeTypes.put("OTHER", new LocalizedString(pt, "Outra").with(en, "Other"));
        for (Map.Entry entry : documentPurposeTypes.entrySet()) {
            DocumentPurposeTypeInstance dpti2;
            if (DocumentPurposeTypeInstance.findUnique((String)((String)entry.getKey())) == null) {
                try {
                    DocumentPurposeType documentPurposeType = DocumentPurposeType.valueOf((String)((String)entry.getKey()));
                    dpti2 = DocumentPurposeTypeInstance.create((String)((String)entry.getKey()), (LocalizedString)((LocalizedString)entry.getValue()), (DocumentPurposeType)documentPurposeType);
                }
                catch (IllegalArgumentException iae) {
                    dpti2 = DocumentPurposeTypeInstance.create((String)((String)entry.getKey()), (LocalizedString)((LocalizedString)entry.getValue()));
                }
            } else {
                dpti2 = DocumentPurposeTypeInstance.findUnique((String)((String)entry.getKey()));
                dpti2.setName((LocalizedString)entry.getValue());
            }
            dpti2.setActive(Boolean.valueOf(true));
            for (ServiceRequestType srt : dpti2.getServiceRequestTypesSet()) {
                dpti2.removeServiceRequestTypes(srt);
            }
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"SCHOOL_REGISTRATION_CERTIFICATE").get());
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"SCHOOL_REGISTRATION_DECLARATION").get());
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"ENROLMENT_CERTIFICATE").get());
            dpti2.addServiceRequestTypes((ServiceRequestType)ServiceRequestType.findUniqueByCode((String)"ENROLMENT_DECLARATION").get());
        }
        DocumentPurposeTypeInstance.findActives().filter(dpti -> !documentPurposeTypes.containsKey(dpti.getCode())).forEach(dpti -> dpti.setActive(Boolean.valueOf(false)));
        DocumentSigner.create(AdministrativeOffice.readDegreeAdministrativeOffice(), "Helena Barreira", "Helena Barreira", new LocalizedString(pt, "Chefe do N\u00facleo de Planeamento e Gest\u00e3o Acad\u00e9mica"), new LocalizedString(pt, "Faculdade de Farm\u00e1cia"), Gender.FEMALE);
    }
}

