/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.domain;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.core.IDocumentTemplateService;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.qubdocs.domain.DocumentPrinterConfiguration$callable$getInstance;
import org.fenixedu.qubdocs.domain.DocumentPrinterConfiguration_Base;
import org.fenixedu.qubdocs.domain.DocumentTemplate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DocumentPrinterConfiguration
extends DocumentPrinterConfiguration_Base
implements IDocumentTemplateService {
    private static String DEFAULT_FONTS_PATH;
    public static final Advice advice$getInstance;

    private DocumentPrinterConfiguration() {
        this.setBennu(Bennu.getInstance());
        this.initFontsPath();
        this.setOpenOfficeConverting(true);
    }

    private void initFontsPath() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            String path = System.getenv("WINDIR");
            File fontDirectory = new File(path, "Fonts");
            this.setFontsPath(fontDirectory.getAbsolutePath());
        } else {
            this.setFontsPath(DEFAULT_FONTS_PATH);
        }
    }

    public boolean isOpenOfficeConverting() {
        return this.getOpenOfficeConverting() != null && this.getOpenOfficeConverting() != false;
    }

    public Set<? extends DocumentTemplate> readAllDocuments() {
        return Bennu.getInstance().getDocumentTemplatesSet();
    }

    public Set<? extends DocumentTemplate> readActiveDocuments() {
        return Sets.filter(this.readAllDocuments(), DocumentTemplate.filters.active(true));
    }

    public static DocumentPrinterConfiguration getInstance() {
        return (DocumentPrinterConfiguration)((Object)advice$getInstance.perform((Callable)new DocumentPrinterConfiguration$callable$getInstance()));
    }

    static /* synthetic */ DocumentPrinterConfiguration advised$getInstance() {
        if (Bennu.getInstance().getDocumentPrinterConfiguration() == null) {
            return DocumentPrinterConfiguration.initialize();
        }
        return Bennu.getInstance().getDocumentPrinterConfiguration();
    }

    private static DocumentPrinterConfiguration initialize() {
        if (Bennu.getInstance().getDocumentPrinterConfiguration() == null) {
            return new DocumentPrinterConfiguration();
        }
        return Bennu.getInstance().getDocumentPrinterConfiguration();
    }

    static {
        advice$getInstance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        DEFAULT_FONTS_PATH = "/usr/share/fonts";
    }
}

