/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.Collection;
import java.util.Set;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.ICreditsTransferRemarksCollection;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class CurriculumEntryRemarksDataProvider
implements IReportDataProvider {
    protected static final String KEY = "curriculumEntryRemarks";
    private Set<RemarkEntry> remarkEntries = Sets.newLinkedHashSet();
    protected String key = "curriculumEntryRemarks";
    protected Registration registration;
    private ICreditsTransferRemarksCollection creditsTransferRemarks;

    public CurriculumEntryRemarksDataProvider(Registration registration, Collection<ICurriculumEntry> entries, CurriculumEntryServices service) {
        this.registration = registration;
        this.creditsTransferRemarks = service.buildRemarksFor(entries, registration.getLastStudentCurricularPlan());
        this.creditsTransferRemarks.getRemarkIds().forEach(remarkId -> this.remarkEntries.add(new RemarkEntry((String)remarkId, this.creditsTransferRemarks.getRemarkTextForId((String)remarkId))));
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
    }

    public boolean handleKey(String key) {
        return this.key.equals(key);
    }

    public Object valueForKey(String key) {
        if (!this.handleKey(key)) {
            return null;
        }
        return this.remarkEntries;
    }

    public String getRemarkIdsFor(CurriculumEntry curriculumEntry) {
        return this.creditsTransferRemarks.getRemarkIdsFor(curriculumEntry.getICurriculumEntry());
    }

    public class RemarkEntry {
        private String remarkNumber;
        private LocalizedString description;

        public RemarkEntry(String remarkNumber, LocalizedString description) {
            this.remarkNumber = remarkNumber;
            this.description = description;
        }

        public String getRemarkNumber() {
            return this.remarkNumber;
        }

        public void setRemarkNumber(String remarkNumber) {
            this.remarkNumber = remarkNumber;
        }

        public void setDescription(LocalizedString description) {
            this.description = description;
        }

        public LocalizedString getDescription() {
            return this.description;
        }
    }
}

