/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntryRemarksDataProvider;
import org.fenixedu.qubdocs.util.CurriculumEntryServices;

public class ConcludedCurriculumEntriesDataProvider
implements IReportDataProvider {
    protected static final String KEY = "concludedCurriculumEntries";
    protected static final String KEY_FOR_REMARKS = "conclusionRemarks";
    protected static final String KEY_FOR_TOTAL_UNITS = "totalConclusions";
    protected static final String KEY_FOR_TOTAL_ECTS = "totalConcludedECTS";
    private final Registration registration;
    private final CurriculumEntryRemarksDataProvider remarksDataProvider;
    private final Locale locale;
    private final Collection<ICurriculumEntry> conclusions;
    private Set<CurriculumEntry> curriculumEntries;
    private final CurriculumEntryServices service;

    public ConcludedCurriculumEntriesDataProvider(Registration registration, Collection<ICurriculumEntry> conclusions, Locale locale, CurriculumEntryServices service) {
        this.registration = registration;
        this.locale = locale;
        this.remarksDataProvider = new CurriculumEntryRemarksDataProvider(registration, conclusions, service);
        this.conclusions = conclusions;
        this.service = service;
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY);
        documentFieldsData.registerCollectionAsField(KEY_FOR_REMARKS);
    }

    public boolean handleKey(String key) {
        if (this.conclusions == null || this.conclusions.isEmpty()) {
            return false;
        }
        return KEY.equals(key) || KEY_FOR_REMARKS.equals(key) || KEY_FOR_TOTAL_UNITS.equals(key) || KEY_FOR_TOTAL_ECTS.equals(key);
    }

    public Object valueForKey(String key) {
        if (key.equals(KEY)) {
            return this.getCurriculumEntries();
        }
        if (key.equals(KEY_FOR_REMARKS)) {
            return this.getRemarks();
        }
        if (key.equals(KEY_FOR_TOTAL_UNITS)) {
            return this.getTotalConclusions();
        }
        if (key.equals(KEY_FOR_TOTAL_ECTS)) {
            return this.getConcludedEcts();
        }
        return null;
    }

    private Set<CurriculumEntry> getCurriculumEntries() {
        if (this.curriculumEntries == null) {
            HashSet entries = Sets.newHashSet(this.conclusions);
            this.curriculumEntries = Sets.newTreeSet((Comparator)new Comparator<CurriculumEntry>(){

                @Override
                public int compare(CurriculumEntry left, CurriculumEntry right) {
                    if (left.getExecutionYear() == right.getExecutionYear()) {
                        return this.compareByName(left, right);
                    }
                    return left.getExecutionYear().compareTo(right.getExecutionYear());
                }

                public int compareByName(CurriculumEntry left, CurriculumEntry right) {
                    String leftContent = left.getName().getContent(ConcludedCurriculumEntriesDataProvider.this.locale) != null ? left.getName().getContent(ConcludedCurriculumEntriesDataProvider.this.locale) : left.getName().getContent();
                    String rightContent = right.getName().getContent(ConcludedCurriculumEntriesDataProvider.this.locale) != null ? right.getName().getContent(ConcludedCurriculumEntriesDataProvider.this.locale) : right.getName().getContent();
                    int result = (leftContent = leftContent.toLowerCase()).compareTo(rightContent = rightContent.toLowerCase());
                    if (result == 0) {
                        return this.compareByCode(left, right);
                    }
                    return result;
                }

                public int compareByCode(CurriculumEntry left, CurriculumEntry right) {
                    String rightCode;
                    String leftCode = left.getICurriculumEntry().getCode();
                    int result = leftCode.compareTo(rightCode = right.getICurriculumEntry().getCode());
                    if (result == 0) {
                        return this.compareByExternalId(left, right);
                    }
                    return result;
                }

                public int compareByExternalId(CurriculumEntry left, CurriculumEntry right) {
                    String leftExternalId = left.getICurriculumEntry().getExternalId();
                    String rightExternalId = right.getICurriculumEntry().getExternalId();
                    return leftExternalId.compareTo(rightExternalId);
                }
            });
            this.curriculumEntries.addAll(CurriculumEntry.transform(this.registration, entries, this.remarksDataProvider, this.service));
        }
        return this.curriculumEntries;
    }

    private int getTotalConclusions() {
        if (this.curriculumEntries == null) {
            return 0;
        }
        return this.curriculumEntries.size();
    }

    private BigDecimal getConcludedEcts() {
        if (this.curriculumEntries == null) {
            return BigDecimal.ZERO;
        }
        return this.curriculumEntries.stream().map(CurriculumEntry::getEctsCredits).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Object getRemarks() {
        return this.remarksDataProvider.valueForKey("curriculumEntryRemarks");
    }
}

