/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs;

import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.util.IReportDataProvider;
import com.qubit.terra.docs.util.ReportGenerationException;
import com.qubit.terra.docs.util.ReportGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.fenixedu.qubdocs.domain.DocumentTemplate;
import org.fenixedu.qubdocs.util.reports.helpers.CurricularHelper;
import org.fenixedu.qubdocs.util.reports.helpers.DateHelper;
import org.fenixedu.qubdocs.util.reports.helpers.EnumerationHelper;
import org.fenixedu.qubdocs.util.reports.helpers.LanguageHelper;
import org.fenixedu.qubdocs.util.reports.helpers.MoneyHelper;
import org.fenixedu.qubdocs.util.reports.helpers.NumbersHelper;
import org.fenixedu.qubdocs.util.reports.helpers.SortHelper;
import org.fenixedu.qubdocs.util.reports.helpers.StringsHelper;

public class FenixEduDocumentGenerator
extends ReportGenerator {
    protected FenixEduDocumentGenerator(DocumentTemplate documentTemplate, String mimeType) {
        this(documentTemplate.getDocumentTemplateFile().getContent(), mimeType);
    }

    protected FenixEduDocumentGenerator(byte[] template, String mimeType) {
        super(template, DocumentTemplateEngine.getServiceImplementation().getFontsPath(), mimeType);
        this.registerHelpers();
    }

    private void registerHelpers() {
        this.registerHelper("dates", new DateHelper());
        this.registerHelper("lang", new LanguageHelper());
        this.registerHelper("order", new SortHelper());
        this.registerHelper("numbers", new NumbersHelper());
        this.registerHelper("enumeration", new EnumerationHelper());
        this.registerHelper("strings", new StringsHelper());
        this.registerHelper("money", new MoneyHelper());
        this.registerHelper("curricular", new CurricularHelper());
    }

    public FenixEduDocumentGenerator registerDataProviders(Collection<? extends IReportDataProvider> providers) {
        for (IReportDataProvider iReportDataProvider : providers) {
            this.registerDataProvider(iReportDataProvider);
        }
        return this;
    }

    public static FenixEduDocumentGenerator create(byte[] template, String mimeType) {
        return new FenixEduDocumentGenerator(template, mimeType);
    }

    public static FenixEduDocumentGenerator create(DocumentTemplate documentTemplate, String mimeType) {
        return new FenixEduDocumentGenerator(documentTemplate, mimeType);
    }

    public static FenixEduDocumentGenerator create(String template, String mimeType) {
        try {
            return new FenixEduDocumentGenerator(FileUtils.readFileToByteArray((File)new File(template)), mimeType);
        }
        catch (FileNotFoundException e) {
            throw new ReportGenerationException("Template file was not found. Maybe this soft reference is inconsistent, try re-upload this template.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Error retrieving the template.", (Throwable)e);
        }
    }
}

