/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;

public class DocsStringUtils
extends StringUtils {
    public static String SINGLE_SPACE = " ";

    public static String trimToEmpty(Object input) {
        return input == null ? "" : DocsStringUtils.trimToEmpty((String)input.toString());
    }

    public static String trimToNull(Object input) {
        return input == null ? null : DocsStringUtils.trimToNull((String)input.toString());
    }

    public static boolean equalsTrimmed(String o1, String o2) {
        return DocsStringUtils.equals((String)DocsStringUtils.trimToEmpty((String)o1), (String)DocsStringUtils.trimToEmpty((String)o2));
    }

    public static boolean equalsTrimmedIgnoreCase(String o1, String o2) {
        return DocsStringUtils.equalsIgnoreCase((String)DocsStringUtils.trimToEmpty((String)o1), (String)DocsStringUtils.trimToEmpty((String)o2));
    }

    public static boolean equals(LocalizedString o1, LocalizedString o2, Locale locale) {
        boolean result;
        boolean bl = result = o1 != null && o2 != null;
        if (result) {
            result = DocsStringUtils.equals((String)DocsStringUtils.normalize(o1.getContent(locale)), (String)DocsStringUtils.normalize(o2.getContent(locale)));
        }
        return result;
    }

    public static String normalize(String string) {
        String result = null;
        if (StringUtils.isNotBlank((String)string)) {
            String spacesReplacedString = DocsStringUtils.removeDuplicateSpaces(string.trim());
            result = StringNormalizer.normalize((String)spacesReplacedString).toLowerCase();
        }
        return result;
    }

    protected static String removeDuplicateSpaces(String string) {
        Pattern pattern = Pattern.compile("\\s+");
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll(" ");
    }

    public static LocalizedString getI18N(String defaultContent, String english) {
        LocalizedString result = new LocalizedString();
        if (DocsStringUtils.isNotBlank((String)defaultContent)) {
            result = result.with(I18N.getLocale(), defaultContent.trim());
        }
        if (DocsStringUtils.isNotBlank((String)english)) {
            result = result.with(new Locale("en", "GB"), english.trim());
        }
        return result;
    }

    public static LocalizedString capitalize(LocalizedString i18nString) {
        LocalizedString result = new LocalizedString();
        for (Locale locale : i18nString.getLocales()) {
            result = result.with(locale, DocsStringUtils.capitalize((String)i18nString.getContent(locale)));
        }
        return result;
    }

    public static LocalizedString joinLS(Collection<LocalizedString> collection, String separator) {
        HashSet locales = new HashSet();
        for (LocalizedString iter : collection) {
            locales.addAll(iter.getLocales());
        }
        LocalizedString result = new LocalizedString();
        for (Locale locale : locales) {
            ArrayList<String> messages = new ArrayList<String>();
            for (LocalizedString i18nString : collection) {
                messages.add(i18nString.getContent(locale));
            }
            result = result.with(locale, DocsStringUtils.join(messages, (String)separator));
        }
        return result;
    }

    public static boolean isEmpty(LocalizedString i18nString) {
        if (i18nString == null || i18nString.isEmpty()) {
            return true;
        }
        if (i18nString.getLocales().isEmpty()) {
            return true;
        }
        for (Locale locale : i18nString.getLocales()) {
            if (!DocsStringUtils.isNotEmpty((String)i18nString.getContent(locale))) continue;
            return false;
        }
        return true;
    }

    public static String replaceVariables(String template, String prefix, String suffix, Map<String, String> variables) {
        return new StrSubstitutor(variables, prefix, suffix).replace(template);
    }
}

