/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.ui.institutionconfiguration;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.domain.InstitutionLogo;
import org.fenixedu.qubdocs.domain.InstitutionReportConfiguration;
import org.fenixedu.qubdocs.ui.FenixeduQubdocsReportsBaseController;
import org.fenixedu.qubdocs.ui.FenixeduQubdocsReportsController;
import org.fenixedu.qubdocs.ui.institutionconfiguration.InstitutionConfigurationController$callable$update;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduQubdocsReportsController.class, title="label.title.institutionConfiguration", accessGroup="logged")
@RequestMapping(value={"/qubdocsreports/institutionconfiguration"})
public class InstitutionConfigurationController
extends FenixeduQubdocsReportsBaseController {
    public static final String CONTROLLER_URL = "/qubdocsreports/institutionconfiguration";
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/qubdocsreports/institutionconfiguration/read";
    private static final String _UPDATE_URI = "/update";
    public static final String UPDATE_URL = "/qubdocsreports/institutionconfiguration/update";
    private static final String _DOWNLOAD_URI = "/download";
    public static final String DOWNLOAD_URL = "/qubdocsreports/institutionconfiguration/download";
    public static final Advice advice$update = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private void setInstitutionConfiguration(InstitutionReportConfiguration institutionReportConfiguration, Model model) {
        model.addAttribute("institutionReportConfiguration", (Object)institutionReportConfiguration);
    }

    @RequestMapping
    public String home(Model model) {
        return "forward:/qubdocsreports/institutionconfiguration/read";
    }

    @RequestMapping(value={"/read"})
    public String read(Model model) {
        this.setInstitutionConfiguration(InstitutionReportConfiguration.getInstance(), model);
        return "qubdocsreports/institutionReportConfiguration/read";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.GET})
    public String update(Model model) {
        this.setInstitutionConfiguration(InstitutionReportConfiguration.getInstance(), model);
        return "qubdocsreports/institutionReportConfiguration/update";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@RequestParam(value="institutionName", required=true) LocalizedString institutionName, @RequestParam(value="institutionShortName", required=true) LocalizedString institutionShortName, @RequestParam(value="institutionAddress", required=true) String institutionAddress, @RequestParam(value="institutionSite", required=true) String institutionSite, @RequestParam(value="logoFile", required=false) MultipartFile logoFile, @RequestParam(value="letterheadLogoFile", required=false) MultipartFile letterheadLogoFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            InstitutionReportConfiguration configuration = InstitutionReportConfiguration.getInstance();
            this.update(institutionName, institutionShortName, institutionAddress, institutionSite, logoFile, letterheadLogoFile);
            this.setInstitutionConfiguration(configuration, model);
            return this.redirect(READ_URL, model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/FenixeduQubdocsReportsResources", (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.update(model);
        }
    }

    private void update(LocalizedString localizedString, LocalizedString localizedString2, String string, String string2, MultipartFile multipartFile, MultipartFile multipartFile2) throws IOException {
        Object object = advice$update.perform((Callable)new InstitutionConfigurationController$callable$update(this, localizedString, localizedString2, string, string2, multipartFile, multipartFile2));
    }

    static /* synthetic */ void advised$update(InstitutionConfigurationController this_, LocalizedString institutionName, LocalizedString institutionShortName, String institutionAddress, String institutionSite, MultipartFile logoFile, MultipartFile letterheadLogoFile) throws IOException {
        InstitutionReportConfiguration configuration = InstitutionReportConfiguration.getInstance();
        configuration.setName(institutionName);
        configuration.setShortName(institutionShortName);
        configuration.setAddress(institutionAddress);
        configuration.setSite(institutionSite);
        if (!logoFile.isEmpty()) {
            if (configuration.getInstitutionLogo() != null) {
                configuration.getInstitutionLogo().delete();
            }
            InstitutionLogo institutionLogo = new InstitutionLogo(logoFile.getOriginalFilename(), logoFile.getBytes());
            configuration.setInstitutionLogo(institutionLogo);
        }
        if (!letterheadLogoFile.isEmpty()) {
            if (configuration.getLetterheadInstitutionLogo() != null) {
                configuration.getLetterheadInstitutionLogo().delete();
            }
            InstitutionLogo letterheadInstitutionLogo = new InstitutionLogo(letterheadLogoFile.getOriginalFilename(), letterheadLogoFile.getBytes());
            configuration.setLetterheadInstitutionLogo(letterheadInstitutionLogo);
        }
    }

    @RequestMapping(value={"/download/{logoFileId}"}, method={RequestMethod.GET})
    public void processSearchToDownloadAction(@PathVariable(value="logoFileId") InstitutionLogo institutionLogo, HttpServletResponse response) {
        try {
            response.setContentType(institutionLogo.getContentType());
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)institutionLogo.getFilename()).replaceAll("\\s", "_"), "UTF-8");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(institutionLogo.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

