/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.ExtraCurricularActivity;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;

public class ExtraCurricularActivitiesDataProvider
implements IReportDataProvider {
    protected static final String KEY = "extraCurricularActivities";
    protected static final String KEY_FOR_LIST = "extraCurricularActivitiesList";
    protected final Comparator<ExtraCurricularActivity> EXTRA_CURRICULAR_ACTIVITY_COMPARATOR = new Comparator<ExtraCurricularActivity>(){

        @Override
        public int compare(ExtraCurricularActivity o1, ExtraCurricularActivity o2) {
            int resultByType = o1.getType().getName().getContent(ExtraCurricularActivitiesDataProvider.this.locale).compareTo(o2.getType().getName().getContent(ExtraCurricularActivitiesDataProvider.this.locale));
            if (resultByType != 0) {
                return resultByType;
            }
            return o1.getStart().compareTo((ReadablePartial)o2.getStart());
        }
    };
    protected Student student;
    protected TreeSet<ExtraCurricularActivity> activities;
    protected Interval interval;
    protected Locale locale;

    public ExtraCurricularActivitiesDataProvider(Student student, Interval interval, Locale locale) {
        this.student = student;
        this.interval = interval;
        this.locale = locale;
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        documentFieldsData.registerCollectionAsField(KEY_FOR_LIST);
    }

    public boolean handleKey(String key) {
        return KEY.equals(key) || KEY_FOR_LIST.equals(key);
    }

    public Object valueForKey(String key) {
        if (KEY.equals(key)) {
            return this;
        }
        if (KEY_FOR_LIST.equals(key)) {
            return this.getActivities();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getActivities().isEmpty();
    }

    public Set<ExtraCurricularActivity> getActivities() {
        if (this.activities == null) {
            TreeSet result = Sets.newTreeSet(this.EXTRA_CURRICULAR_ACTIVITY_COMPARATOR);
            for (ExtraCurricularActivity extraCurricularActivity : this.student.getExtraCurricularActivitySet()) {
                if (!this.interval.overlaps((ReadableInterval)extraCurricularActivity.getActivityInterval())) continue;
                result.add(extraCurricularActivity);
            }
            this.activities = result;
        }
        return this.activities;
    }
}

