/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.base.providers;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.fenixedu.qubdocs.preprocessors.QubListPreProcessor;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.Section;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class QubListDataProvider
implements IReportDataProvider {
    Document document;
    List<String> listVariables;

    public QubListDataProvider(byte[] templateContent) {
        try {
            this.document = Document.loadDocument((InputStream)new ByteArrayInputStream(templateContent));
            this.listVariables = new ArrayList<String>();
            this.processDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating Odf Document. " + e.getMessage());
        }
    }

    public byte[] getFinalTemplateVersion() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            this.document.save((OutputStream)byteArray);
            return byteArray.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in generating final version of template. " + e.getMessage());
        }
    }

    protected void processDocument() {
        for (Table table : this.document.getTableList()) {
            if (table.getColumnCount() != 1 || table.getRowCount() != 1 || !table.getCellByPosition(0, 0).getDisplayText().contains("qubList")) continue;
            this.processCellNodes(table.getCellByPosition(0, 0).getOdfElement().getChildNodes());
        }
        Iterator sectionIterator = this.document.getSectionIterator();
        while (sectionIterator.hasNext()) {
            Section section = (Section)sectionIterator.next();
            if (!section.getOdfElement().getTextContent().contains("qubList")) continue;
            this.processCellNodes(section.getOdfElement().getChildNodes());
        }
    }

    protected void processCellNodes(NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child instanceof Text) {
                this.processCellText((Text)child);
                continue;
            }
            this.processCellNodes(child.getChildNodes());
        }
    }

    protected void processCellText(Text node) {
        Matcher matcher = QubListPreProcessor.PATTERN.matcher(node.getData());
        while (matcher.find()) {
            String[] includes;
            for (String include : includes = matcher.group(1).split(" ")) {
                this.listVariables.add(include);
            }
        }
        node.setData(matcher.replaceAll(""));
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
        for (String listVariable : this.listVariables) {
            documentFieldsData.registerCollectionAsField(listVariable);
        }
    }

    public boolean handleKey(String key) {
        return false;
    }

    public Object valueForKey(String key) {
        return null;
    }
}

